<?php
session_start();
require '../assets/db_connect.php';
require '../libraries/php-qrcode-main/qrlib.php'; // adjust path to your QR library

if (!isset($_GET['id'])) {
    echo "<div style='color:red;'>Sale ID missing.</div>";
    exit;
}

$sale_id = intval($_GET['id']);

// Fetch sale
$stmt = $pdo->prepare("
    SELECT s.*, c.name AS customer_name, u.username AS created_by_name
    FROM sales s
    LEFT JOIN customers c ON s.customer_id = c.id
    LEFT JOIN users u ON s.created_by = u.id
    WHERE s.id = ?
");
$stmt->execute([$sale_id]);
$sale = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$sale) {
    echo "<div style='color:red;'>Sale not found.</div>";
    exit;
}

// Fetch sale items
$stmt_items = $pdo->prepare("
    SELECT sl.*, p.name AS product_name, b.batch_no
    FROM sale_lines sl
    LEFT JOIN products p ON sl.product_id = p.id
    LEFT JOIN product_batches b ON sl.batch_id = b.id
    WHERE sl.sale_id = ?
");
$stmt_items->execute([$sale_id]);
$items = $stmt_items->fetchAll(PDO::FETCH_ASSOC);

// Generate QR code
$qrTempDir = "../temp_qr/";
if (!is_dir($qrTempDir)) mkdir($qrTempDir);

$qrFilename = $qrTempDir . $sale['invoice_no'] . ".png";
$qrData = "Invoice: {$sale['invoice_no']}\nDate: {$sale['sale_date']}\nTotal: {$sale['total']}";
QRcode::png($qrData, $qrFilename, QR_ECLEVEL_L, 3);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Invoice <?= htmlspecialchars($sale['invoice_no']) ?></title>
    <style>
        @media print {
            body {
                width: 58mm; /* change to 80mm if needed */
                font-family: 'Courier New', monospace;
                font-size: 12px;
                margin: 0;
                padding: 0;
            }
            .receipt-header, .receipt-footer {
                text-align: center;
            }
            table {
                width: 100%;
                border-collapse: collapse;
                margin-top: 5px;
            }
            table th, table td {
                padding: 2px 0;
                border-bottom: 1px dashed #000;
                text-align: left;
            }
            .qr img {
                width: 100px;
                height: auto;
                margin-top: 5px;
            }
        }
    </style>
</head>
<body onload="window.print(); setTimeout(() => window.close(), 1000);">

<div class="receipt">
    <div class="receipt-header">
        <h3>Mugana Pharmacy</h3>
        <p>Invoice: <?= htmlspecialchars($sale['invoice_no']) ?></p>
        <p>Date: <?= date('d-M-Y H:i', strtotime($sale['sale_date'])) ?></p>
        <p>Status: <?= htmlspecialchars($sale['status']) ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Item</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($items as $it): ?>
            <tr>
                <td><?= htmlspecialchars($it['product_name']) ?></td>
                <td><?= $it['qty'] ?></td>
                <td><?= number_format($it['unit_price'],2) ?></td>
                <td><?= number_format($it['line_total'],2) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="receipt-footer">
        <p>Total: <?= number_format($sale['total'],2) ?></p>
        <p>Paid: <?= number_format($sale['paid'],2) ?></p>
        <p>Balance: <?= number_format($sale['total'] - $sale['paid'],2) ?></p>

        <div class="qr">
            <img src="<?= $qrFilename ?>" alt="QR Code">
            <p>Scan QR</p>
        </div>
    </div>
</div>

</body>
</html>
