<?php
// modules/sales/index.php
session_start();
require_once '../assets/db_connect.php'; // <- adjust path
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

// Only admin or cashier roles could access — adjust as needed
// if (!in_array($_SESSION['role'], ['admin','cashier'])) { header("Location: ../../index.php"); exit; }

?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="text-success">Sales</h3>
        <a href="add_sale.php" class="btn btn-primary">+ New Sale</a>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-hover" id="salesTable">
            <thead class="thead-light">
                <tr>
                    <th>ID</th>
                    <th>Invoice</th>
                    <th>Date</th>
                    <th>Customer</th>
                    <th>Total</th>
                    <th>Paid</th>
                    <th>Status</th>
                    <th>Created By</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php
            $stmt = $pdo->query("
                SELECT s.*, c.name AS customer_name, u.username AS created_by_name
                FROM sales s
                LEFT JOIN customers c ON s.customer_id = c.id
                LEFT JOIN users u ON s.created_by = u.id
                ORDER BY s.id DESC
            ");
            while ($r = $stmt->fetch(PDO::FETCH_ASSOC)):
            ?>
                <tr id="row-<?= $r['id'] ?>">
                    <td><?= $r['id'] ?></td>
                    <td><?= htmlspecialchars($r['invoice_no']) ?></td>
                    <td><?= date('d-M-Y H:i', strtotime($r['sale_date'])) ?></td>
                    <td><?= htmlspecialchars($r['customer_name'] ?? '-') ?></td>
                    <td><?= number_format($r['total'], 2) ?></td>
                    <td><?= number_format($r['paid'], 2) ?></td>
                    <td><?= htmlspecialchars($r['status']) ?></td>
                    <td><?= htmlspecialchars($r['created_by_name'] ?? '-') ?></td>
                    <td>
                        <a href="view_sale.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-info">View</a>
                        <a href="edit_sale.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <button class="btn btn-sm btn-danger" onclick="deleteSale(<?= $r['id'] ?>)">Delete</button>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?>

<script>
function deleteSale(id) {
    if (!confirm("Delete this sale? This will restore stock levels.")) return;
    $.ajax({
        url: 'delete_sale.php',
        type: 'POST',
        data: { id: id },
        dataType: 'json',
        success: function(res) {
            if (res.status === 'success') {
                $("#row-" + id).fadeOut(300, function(){ $(this).remove(); });
                alert(res.message);
            } else {
                alert(res.message);
            }
        },
        error: function(xhr, status, err) {
            console.error(err);
            alert("Error deleting sale");
        }
    });
}
</script>
