<?php
require '../assets/db_connect.php';

$term = trim($_GET['term'] ?? '');
if (!$term) exit(json_encode([]));

$stmt = $pdo->prepare("SELECT id, name FROM products WHERE name LIKE ? ORDER BY name LIMIT 10");
$stmt->execute(["%$term%"]);
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Format results for frontend
$data = [];
foreach ($results as $row) {
    $data[] = [
        'id' => $row['id'],
        'text' => $row['name']
    ];
}

echo json_encode($data);
