<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <h3 class="mb-4 text-success">New Sale</h3>

    <form id="saleForm">

        <!-- CUSTOMER NAME -->
        <div class="form-group">
            <label>Customer Name (optional)</label>
            <input type="text" class="form-control" name="customer_name" placeholder="Type customer name">
        </div>

        <!-- INVOICE NO (display only, generated on save) -->
        <div class="form-group">
            <label>Invoice Number</label>
            <input type="text" class="form-control" id="invoice_no" value="(will be generated)" readonly>
        </div>

        <!-- PRODUCT SEARCH -->
        <div class="card p-3 mb-4">
            <h5>Add Product</h5>
            <div class="form-group">
                <label>Search Product</label>
                <input type="text" id="productSearch" class="form-control" placeholder="Type product name...">
                <div id="productResults" class="list-group mt-1" style="display:none; max-height:180px; overflow-y:auto;"></div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-4">
                    <label>Selected Product</label>
                    <input type="text" id="selectedProductName" class="form-control" readonly>
                    <input type="hidden" id="selectedProductId">
                </div>

                <div class="form-group col-md-4">
                    <label>Batch (auto)</label>
                    <input type="text" id="batchInfo" class="form-control" readonly>
                    <input type="hidden" id="batchId">
                </div>

                <div class="form-group col-md-2">
                    <label>Price</label>
                    <input type="number" class="form-control" id="unitPrice" readonly>
                </div>

                <div class="form-group col-md-2">
                    <label>Available</label>
                    <input type="text" class="form-control" id="qtyAvailable" readonly>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group col-md-3">
                    <label>Quantity</label>
                    <input type="number" id="qty" class="form-control" min="1" value="1">
                </div>

                <div class="form-group col-md-3">
                    <label>Discount</label>
                    <input type="number" id="discount" class="form-control" value="0">
                </div>

                <div class="form-group col-md-3">
                    <label>&nbsp;</label><br>
                    <button type="button" id="addItemBtn" class="btn btn-primary btn-block">Add Item</button>
                </div>
            </div>
        </div>

        <!-- ITEMS TABLE -->
        <table class="table table-bordered" id="itemsTable">
            <thead class="thead-light">
                <tr>
                    <th>Product</th>
                    <th>Batch</th>
                    <th>Qty</th>
                    <th>Price</th>
                    <th>Discount</th>
                    <th>Total</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>

        <!-- PAYMENT -->
        <div class="form-group">
            <label>Amount Paid</label>
            <input type="number" class="form-control" name="paid" value="0">
        </div>

        <!-- TOTAL -->
        <div class="form-group">
            <h4>Total: <span id="grandTotal">0.00</span></h4>
        </div>

        <button type="submit" class="btn btn-success btn-lg">Save Sale</button>
    </form>
</div>

<?php require_once '../includes/footer.php'; ?>

<script>
$(document).ready(function(){

    // PRODUCT SEARCH
    $("#productSearch").keyup(function() {
        let query = $(this).val();
        if(query.length < 2){ $("#productResults").hide(); return; }

        $.post("search_product.php", {query: query}, function(data){
            $("#productResults").html(data).show();
        });
    });

    // SELECT PRODUCT
    $(document).on("click",".product-item",function(){
        let product_id = $(this).data("id");
        let name = $(this).text();
        $("#selectedProductName").val(name);
        $("#selectedProductId").val(product_id);
        $("#productResults").hide();
        $("#productSearch").val("");

        // GET DEFAULT BATCH
        $.post("get_default_batch.php", {product_id: product_id}, function(res){
            if(res.status==="success"){
                $("#batchInfo").val(res.batch_no+" (exp: "+res.expiry+")");
                $("#batchId").val(res.batch_id);
                $("#unitPrice").val(res.price);
                $("#qtyAvailable").val(res.qty);
            }else{
                alert(res.message);
            }
        }, 'json');
    });

    // ADD ITEM
    $("#addItemBtn").click(function(){
        let name=$("#selectedProductName").val();
        let product_id=$("#selectedProductId").val();
        let batch_id=$("#batchId").val();
        let qty=parseInt($("#qty").val());
        let price=parseFloat($("#unitPrice").val());
        let discount=parseFloat($("#discount").val());
        let available=parseInt($("#qtyAvailable").val());

        if(!product_id) return alert("Select a product first");
        if(!batch_id) return alert("Batch not found");
        if(qty<=0) return alert("Enter quantity");
        if(qty>available) return alert("Not enough stock");

        let total=(qty*price)-discount;
        if(total<0) total=0;

        let index = $('#itemsTable tbody tr').length;

        let row = `<tr>
            <td>${name}<input type="hidden" name="items[${index}][product_id]" value="${product_id}"></td>
            <td>${batch_id}<input type="hidden" name="items[${index}][batch_id]" value="${batch_id}"></td>
            <td>${qty}<input type="hidden" name="items[${index}][qty]" value="${qty}"></td>
            <td>${price}<input type="hidden" name="items[${index}][unit_price]" value="${price}"></td>
            <td>${discount}<input type="hidden" name="items[${index}][discount]" value="${discount}"></td>
            <td class="lineTotal">${total.toFixed(2)}</td>
            <td><button type="button" class="btn btn-danger btn-sm remove">X</button></td>
        </tr>`;

        $("#itemsTable tbody").append(row);
        calculateTotal();

        // reset selection
        $("#selectedProductName, #selectedProductId, #batchInfo, #batchId, #unitPrice, #qtyAvailable").val('');
        $("#qty").val(1);
        $("#discount").val(0);
    });

    // REMOVE ITEM & REINDEX
    function reindexItems(){
        $('#itemsTable tbody tr').each(function(i){
            $(this).find('input').each(function(){
                let name = $(this).attr('name');
                let newName = name.replace(/items\[\d+\]/,'items['+i+']');
                $(this).attr('name',newName);
            });
        });
    }

    $(document).on("click",".remove",function(){
        $(this).closest("tr").remove();
        calculateTotal();
        reindexItems();
    });

    // CALCULATE TOTAL
    function calculateTotal(){
        let sum=0;
        $(".lineTotal").each(function(){ sum+=parseFloat($(this).text()); });
        $("#grandTotal").text(sum.toFixed(2));
    }

    // SUBMIT SALE
    $('#saleForm').submit(function(e){
        e.preventDefault();
        $.post('save_sale.php', $(this).serialize(), function(res){
            if(res.status==='success'){
                // open printable invoice in new tab
                window.open('print_invoice.php?id='+res.sale_id,'_blank');
                // reset form
                $('#saleForm')[0].reset();
                $('#itemsTable tbody').empty();
                $('#grandTotal').text('0.00');
            } else {
                alert(res.message);
            }
        }, 'json');
    });

});
</script>
