<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$supplier_id = intval($_GET['supplier_id'] ?? 0);

if (!$supplier_id) {
    // show supplier list
    $suppliers = $pdo->query("SELECT * FROM suppliers ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
    echo "<div class='col-md-10 ml-sm-auto px-4 py-4'><h3>Select Supplier</h3><ul>";
    foreach($suppliers as $s) echo "<li><a href='?supplier_id={$s['id']}'>".htmlspecialchars($s['name'])."</a></li>";
    echo "</ul></div>";
    require_once '../includes/footer.php'; exit;
}

$stmt = $pdo->prepare("SELECT * FROM suppliers WHERE id=?"); $stmt->execute([$supplier_id]); $sup = $stmt->fetch();
$rows = $pdo->prepare("SELECT p.*, pl.qty, pl.cost_price FROM purchases p JOIN purchase_lines pl ON pl.purchase_id = p.id WHERE p.supplier_id = ? ORDER BY p.purchase_date DESC");
$rows->execute([$supplier_id]);
$lines = $rows->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
<h3 class="text-success">Statement — <?= htmlspecialchars($sup['name']) ?></h3>

<table class="table table-bordered">
<thead><tr><th>Purchase ID</th><th>Invoice</th><th>Date</th><th>Batch</th><th>Qty</th><th>Cost</th></tr></thead>
<tbody>
<?php foreach($lines as $l): ?>
<tr>
  <td><?= $l['id'] ?></td>
  <td><?= htmlspecialchars($l['invoice_no']) ?></td>
  <td><?= $l['purchase_date'] ?></td>
  <td><?= $l['batch_id'] ?></td>
  <td><?= $l['qty'] ?></td>
  <td><?= number_format($l['cost_price'],2) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>

<?php require_once '../includes/footer.php'; ?>
