<?php
require '../../config/db_connect.php';
session_start();

// Restrict to admin only
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    die("Access Denied. Admins only.");
}

// Default threshold for "low stock"
$threshold = isset($_GET['threshold']) ? intval($_GET['threshold']) : 10;

// Fetch low stock products
$query = $pdo->prepare("
    SELECT 
        p.id,
        p.name,
        p.unit,
        SUM(pb.qty) AS total_qty,
        MIN(pb.expiry_date) AS nearest_expiry
    FROM product_batches pb
    JOIN products p ON p.id = pb.product_id
    GROUP BY pb.product_id
    HAVING total_qty <= ?
    ORDER BY total_qty ASC
");
$query->execute([$threshold]);
$low_stock = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Low Stock Report</title>
    <link rel="stylesheet" href="../../libraries/bootstrap.css">
</head>
<body class="p-4">

<h3>📉 Low Stock Report</h3>
<hr>

<form method="GET" class="form-inline mb-3">
    <label class="mr-2">Threshold:</label>
    <input type="number" name="threshold" value="<?= $threshold ?>" class="form-control mr-2" min="1">
    <button class="btn btn-primary">Filter</button>
</form>

<table class="table table-bordered table-hover">
    <thead class="thead-dark">
        <tr>
            <th>#</th>
            <th>Product</th>
            <th>Unit</th>
            <th>Total Qty</th>
            <th>Nearest Expiry</th>
        </tr>
    </thead>

    <tbody>
        <?php if (empty($low_stock)): ?>
            <tr>
                <td colspan="5" class="text-center text-danger">No low-stock products found</td>
            </tr>
        <?php else: ?>
            <?php foreach ($low_stock as $i => $row): ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td><?= htmlspecialchars($row['name']); ?></td>
                    <td><?= htmlspecialchars($row['unit']); ?></td>
                    <td><b><?= $row['total_qty']; ?></b></td>
                    <td><?= $row['nearest_expiry']; ?></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
    </tbody>
</table>

</body>
</html>
