<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$sql = "
 SELECT p.id AS product_id, p.name AS product_name,
        pb.id AS batch_id, pb.batch_no, pb.qty, pb.cost_price, pb.sell_price, pb.expiry_date,
        s.name AS supplier
 FROM products p
 LEFT JOIN product_batches pb ON pb.product_id = p.id
 LEFT JOIN suppliers s ON s.id = pb.supplier_id
 ORDER BY p.name, pb.expiry_date
";
$rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

if (isset($_GET['export']) && $_GET['export']==='csv') {
    header('Content-Type: text/csv'); header('Content-Disposition: attachment; filename=stock_levels.csv');
    $out = fopen('php://output','w');
    fputcsv($out, ['product_id','product_name','batch_id','batch_no','qty','cost_price','sell_price','expiry_date','supplier']);
    foreach ($rows as $r) fputcsv($out, [$r['product_id'],$r['product_name'],$r['batch_id'],$r['batch_no'],$r['qty'],$r['cost_price'],$r['sell_price'],$r['expiry_date'],$r['supplier']]);
    fclose($out); exit;
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
<h3 class="text-success">Current Stock Levels</h3>
<a class="btn btn-outline-secondary mb-3" href="?export=csv">Export CSV</a>

<div class="table-responsive">
<table class="table table-sm table-bordered">
  <thead>
      <tr>
          <th>Product</th>
          <th>Batch</th>
          <th>Qty</th>
          <th>Cost</th>
          <th>Sell</th>
          <th>Expiry</th>
          <th>Supplier</th>
      </tr>
  </thead>
  <tbody>
  <?php foreach($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['product_name'] ?? '-'); ?></td>
      <td><?= htmlspecialchars($r['batch_no'] ?? '-'); ?></td>
      <td><?= $r['qty'] ?? '-'; ?></td>
      <td><?= number_format($r['cost_price'],2); ?></td>
      <td><?= number_format($r['sell_price'],2); ?></td>
      <td>
        <?= $r['expiry_date'] 
            ? date('d-M-Y', strtotime($r['expiry_date'])) 
            : '-'; ?>
      </td>
      <td><?= htmlspecialchars($r['supplier'] ?? '-'); ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>

</div>
</div>

<?php require_once '../includes/footer.php'; ?>
