<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$today = new DateTimeImmutable();
$rows = $pdo->query("
 SELECT p.name AS product_name, pb.batch_no, pb.qty, pb.expiry_date, s.name AS supplier
 FROM product_batches pb
 JOIN products p ON p.id = pb.product_id
 LEFT JOIN suppliers s ON s.id = pb.supplier_id
 ORDER BY pb.expiry_date ASC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
<h3 class="text-success">Expired / Near Expiry</h3>

<table class="table table-sm table-bordered">
<thead><tr><th>Product</th><th>Batch</th><th>Qty</th><th>Expiry Date</th><th>Days</th><th>Supplier</th></tr></thead>
<tbody>
<?php foreach($rows as $r):
    $days = $r['expiry_date'] ? (new DateTime($r['expiry_date']))->diff(new DateTime())->days : null;
    $status = $r['expiry_date'] ? ((new DateTime($r['expiry_date'])) < new DateTime() ? 'EXPIRED' : $days.' days') : '-';
?>
<tr>
  <td><?= htmlspecialchars($r['product_name']) ?></td>
  <td><?= htmlspecialchars($r['batch_no']) ?></td>
  <td><?= $r['qty'] ?></td>
  <td><?= $r['expiry_date'] ?: '-' ?></td>
  <td><?= $status ?></td>
  <td><?= htmlspecialchars($r['supplier']) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>

<?php require_once '../includes/footer.php'; ?>
