<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$from = $_GET['from'] ?? date('Y-m-d', strtotime('-6 months'));
$to   = $_GET['to'] ?? date('Y-m-d');
$limit = intval($_GET['limit'] ?? 50);

$sql = "
 SELECT p.id, p.name, COALESCE(SUM(sl.qty),0) AS total_qty
 FROM products p
 LEFT JOIN sale_lines sl ON sl.product_id = p.id
 LEFT JOIN sales s ON s.id = sl.sale_id AND DATE(s.sale_date) BETWEEN ? AND ?
 GROUP BY p.id
 ORDER BY total_qty ASC
 LIMIT ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$from,$to,$limit]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// CSV export
if (isset($_GET['export']) && $_GET['export']==='csv') {
    header('Content-Type: text/csv'); header('Content-Disposition: attachment; filename=slow_moving_'.$from.'_'.$to.'.csv');
    $out = fopen('php://output','w');
    fputcsv($out, ['product_id','product_name','total_qty']);
    foreach ($rows as $r) fputcsv($out, [$r['id'],$r['name'],$r['total_qty']]);
    fclose($out); exit;
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
<h3 class="text-success">Slow Moving Drugs</h3>

<form class="form-inline mb-3">
  <label class="mr-2">From</label><input type="date" name="from" value="<?= $from ?>" class="form-control mr-2">
  <label class="mr-2">To</label><input type="date" name="to" value="<?= $to ?>" class="form-control mr-2">
  <label class="mr-2">Limit</label><input type="number" name="limit" value="<?= $limit ?>" class="form-control mr-2" style="width:80px;">
  <button class="btn btn-primary mr-2">Filter</button>
  <a href="?from=<?= $from ?>&to=<?= $to ?>&limit=<?= $limit ?>&export=csv" class="btn btn-outline-secondary">Export CSV</a>
</form>

<table class="table table-sm table-bordered">
  <thead><tr><th>#</th><th>Product</th><th>Qty Sold</th></tr></thead>
  <tbody>
  <?php $i=1; foreach($rows as $r): ?>
    <tr><td><?= $i++ ?></td><td><?= htmlspecialchars($r['name']) ?></td><td><?= $r['total_qty'] ?></td></tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>

<?php require_once '../includes/footer.php'; ?>
