<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to']   ?? date('Y-m-d');

$sql = "
 SELECT s.id, s.invoice_no, s.sale_date, COALESCE(c.name,'Walk-in') AS customer, s.total, s.paid, s.status, u.fullname AS cashier
 FROM sales s
 LEFT JOIN customers c ON s.customer_id = c.id
 LEFT JOIN users u ON s.created_by = u.id
 WHERE DATE(s.sale_date) BETWEEN ? AND ?
 ORDER BY s.sale_date DESC
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$from, $to]);
$sales = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (isset($_GET['export']) && $_GET['export']==='csv') {
    header('Content-Type: text/csv'); header('Content-Disposition: attachment; filename=sales_'.$from.'_'.$to.'.csv');
    $out = fopen('php://output','w');
    fputcsv($out, ['id','invoice_no','sale_date','customer','total','paid','status','cashier']);
    foreach ($sales as $s) fputcsv($out, [$s['id'],$s['invoice_no'],$s['sale_date'],$s['customer'],$s['total'],$s['paid'],$s['status'],$s['cashier']]);
    fclose($out); exit;
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
<h3 class="text-success">Sales Between Dates</h3>

<form class="form-inline mb-3">
  <label class="mr-2">From</label><input type="date" name="from" value="<?= $from ?>" class="form-control mr-2">
  <label class="mr-2">To</label><input type="date" name="to" value="<?= $to ?>" class="form-control mr-2">
  <button class="btn btn-primary mr-2">Filter</button>
  <a href="?from=<?= $from ?>&to=<?= $to ?>&export=csv" class="btn btn-outline-secondary">Export CSV</a>
</form>

<div class="table-responsive">
<table class="table table-bordered">
  <thead><tr><th>ID</th><th>Invoice</th><th>Date</th><th>Customer</th><th>Total</th><th>Paid</th><th>Status</th><th>Cashier</th></tr></thead>
  <tbody>
    <?php foreach($sales as $s): ?>
      <tr>
        <td><?= $s['id'] ?></td>
        <td><?= htmlspecialchars($s['invoice_no']) ?></td>
        <td><?= date('d-M-Y H:i', strtotime($s['sale_date'])) ?></td>
        <td><?= htmlspecialchars($s['customer']) ?></td>
        <td><?= number_format($s['total'],2) ?></td>
        <td><?= number_format($s['paid'],2) ?></td>
        <td><?= htmlspecialchars($s['status']) ?></td>
        <td><?= htmlspecialchars($s['cashier']) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
</div>

<?php require_once '../includes/footer.php'; ?>
