<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$date = $_GET['date'] ?? date('Y-m-d');

$params = [$date, $date];
$sql = "
 SELECT
   DATE(s.sale_date) as sale_date,
   COUNT(DISTINCT s.id) AS invoices,
   SUM(s.total) AS total_revenue,
   SUM(sl.qty) AS total_qty,
   SUM(sl.unit_price * sl.qty - sl.discount) AS calc_total
 FROM sales s
 JOIN sale_lines sl ON sl.sale_id = s.id
 WHERE DATE(s.sale_date) = ?
 GROUP BY DATE(s.sale_date)
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$date]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

// CSV export
if (isset($_GET['export']) && $_GET['export']==='csv') {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename=sales_daily_'.$date.'.csv');
    $out = fopen('php://output','w');
    fputcsv($out, ['date','invoices','total_revenue','total_qty']);
    fputcsv($out, [$date, $row['invoices'] ?? 0, $row['total_revenue'] ?? 0, $row['total_qty'] ?? 0]);
    fclose($out); exit;
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
  <h3 class="text-success">Daily Sales Summary — <?= htmlspecialchars($date) ?></h3>

  <form class="form-inline mb-3">
    <label class="mr-2">Date</label>
    <input type="date" name="date" value="<?= htmlspecialchars($date) ?>" onchange="this.form.submit()" class="form-control mr-2">
    <a href="?date=<?= $date ?>&export=csv" class="btn btn-outline-secondary">Export CSV</a>
  </form>

  <table class="table table-bordered">
    <tr><th>Invoices</th><td><?= $row['invoices'] ?? 0 ?></td></tr>
    <tr><th>Total Revenue</th><td><?= number_format($row['total_revenue'] ?? 0,2) ?></td></tr>
    <tr><th>Total Quantity Sold</th><td><?= $row['total_qty'] ?? 0 ?></td></tr>
  </table>
</div>

<?php require_once '../includes/footer.php'; ?>
