<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');

$sql = "
 SELECT 
   SUM(sl.line_total) AS revenue,
   SUM(pb.cost_price * sl.qty) AS cost,
   SUM(sl.line_total) - SUM(pb.cost_price * sl.qty) AS profit
 FROM sale_lines sl
 JOIN sales s ON s.id = sl.sale_id
 LEFT JOIN product_batches pb ON pb.id = sl.batch_id
 WHERE DATE(s.sale_date) BETWEEN ? AND ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$from,$to]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
<h3 class="text-success">Profit Summary</h3>
<form class="form-inline mb-3">
  <input type="date" name="from" value="<?= $from ?>" class="form-control mr-2">
  <input type="date" name="to" value="<?= $to ?>" class="form-control mr-2">
  <button class="btn btn-primary">Filter</button>
</form>

<table class="table table-bordered">
<tr><th>Revenue</th><td><?= number_format($row['revenue'] ?? 0,2) ?></td></tr>
<tr><th>Cost</th><td><?= number_format($row['cost'] ?? 0,2) ?></td></tr>
<tr><th>Profit</th><td><?= number_format($row['profit'] ?? 0,2) ?></td></tr>
</table>
</div>

<?php require_once '../includes/footer.php'; ?>
