<?php
require "../../config/db_connect.php";
session_start();

// Allow only admins
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'admin') {
    die("Access denied. Admin only.");
}

// Fetch profit per product
$sql = "
    SELECT 
        p.id,
        p.name,
        SUM(sl.qty) AS total_sold,
        SUM(sl.line_total) AS revenue,
        SUM(sl.qty * pb.cost_price) AS total_cost,
        (SUM(sl.line_total) - SUM(sl.qty * pb.cost_price)) AS profit
    FROM sale_lines sl
    JOIN product_batches pb ON pb.id = sl.batch_id
    JOIN products p ON p.id = sl.product_id
    JOIN sales s ON s.id = sl.sale_id
    WHERE s.status != 'cancelled'
    GROUP BY p.id
    ORDER BY profit DESC;
";
$stmt = $pdo->query($sql);
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Profit by Products</title>
    <link rel="stylesheet" href="../../libraries/bootstrap.css">
</head>
<body class="p-4">

<h3>💰 Profit Report (Products)</h3>
<hr>

<table class="table table-bordered table-hover">
    <thead class="thead-dark">
        <tr>
            <th>#</th>
            <th>Product</th>
            <th>Total Sold</th>
            <th>Revenue</th>
            <th>Cost</th>
            <th>Profit</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!$data): ?>
            <tr><td colspan="6" class="text-center">No sales available</td></tr>
        <?php else: ?>
            <?php foreach ($data as $i => $row): ?>
                <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= $row['total_sold'] ?></td>
                    <td><?= number_format($row['revenue'],2) ?></td>
                    <td><?= number_format($row['total_cost'],2) ?></td>
                    <td><b><?= number_format($row['profit'],2) ?></b></td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
    </tbody>
</table>

</body>
</html>
