<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    echo "<div class='col-md-10 ml-sm-auto px-4 py-4'><div class='alert alert-danger'>Access denied.</div></div>";
    require_once '../includes/footer.php';
    exit;
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <h3 class="text-success">Reports</h3>
    <div class="list-group mt-3">
        <a href="sales_daily.php" class="list-group-item list-group-item-action">Sales — Daily Summary</a>
        <a href="sales_range.php" class="list-group-item list-group-item-action">Sales — Between Dates</a>
        <a href="sales_by_product.php" class="list-group-item list-group-item-action">Sales by Product / Top Sellers</a>
        <a href="sales_by_user.php" class="list-group-item list-group-item-action">Sales by User (Cashier)</a>

        <a href="stock_levels.php" class="list-group-item list-group-item-action">Current Stock Levels</a>
        <a href="stock_low.php" class="list-group-item list-group-item-action">Low Stock</a>
        <a href="stock_expiry.php" class="list-group-item list-group-item-action">Expired / Near Expiry</a>

        <a href="fast_moving.php" class="list-group-item list-group-item-action">Fast Moving Drugs</a>
        <a href="slow_moving.php" class="list-group-item list-group-item-action">Slow Moving Drugs</a>

        <a href="purchases_range.php" class="list-group-item list-group-item-action">Purchases — Between Dates</a>
        <a href="supplier_summary.php" class="list-group-item list-group-item-action">Supplier Purchase Summary</a>

        <a href="profit_summary.php" class="list-group-item list-group-item-action">Profit Summary</a>
        <a href="profit_products.php" class="list-group-item list-group-item-action">Profit by Product</a>

        <a href="supplier_statement.php" class="list-group-item list-group-item-action">Supplier Statement</a>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>
