<?php
// modules/suppliers/edit_supplier.php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

// role guard
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    echo "<div class='col-md-10 ml-sm-auto px-4 py-4'><div class='alert alert-danger'>Access denied.</div></div>";
    require_once '../includes/footer.php';
    exit;
}

if (!isset($_GET['id'])) {
    echo "<div class='col-md-10 ml-sm-auto px-4 py-4'><div class='alert alert-danger'>Supplier ID missing.</div></div>";
    require_once '../includes/footer.php';
    exit;
}

$id = intval($_GET['id']);

$stmt = $pdo->prepare("SELECT * FROM suppliers WHERE id = ?");
$stmt->execute([$id]);
$supplier = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$supplier) {
    echo "<div class='col-md-10 ml-sm-auto px-4 py-4'><div class='alert alert-danger'>Supplier not found.</div></div>";
    require_once '../includes/footer.php';
    exit;
}

$errors = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $contact = trim($_POST['contact'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $address = trim($_POST['address'] ?? '');

    if ($name === '') $errors[] = 'Name is required.';

    if (empty($errors)) {
        $stmt = $pdo->prepare("UPDATE suppliers SET name=?, contact=?, email=?, address=? WHERE id=?");
        $stmt->execute([$name, $contact ?: null, $email ?: null, $address ?: null, $id]);
        header("Location: index.php?updated=1");
        exit;
    }
} else {
    // prefill
    $name = $supplier['name'];
    $contact = $supplier['contact'];
    $email = $supplier['email'];
    $address = $supplier['address'];
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <h3 class="text-success mb-4">Edit Supplier</h3>

    <?php if ($errors): ?>
        <div class="alert alert-danger">
            <?php foreach ($errors as $e) echo "<div>" . htmlspecialchars($e) . "</div>"; ?>
        </div>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group">
            <label>Supplier Name <span class="text-danger">*</span></label>
            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
        </div>

        <div class="form-group">
            <label>Contact Person / Phone</label>
            <input type="text" name="contact" class="form-control" value="<?= htmlspecialchars($contact) ?>">
        </div>

        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($email) ?>">
        </div>

        <div class="form-group">
            <label>Address</label>
            <textarea name="address" class="form-control" rows="3"><?= htmlspecialchars($address) ?></textarea>
        </div>

        <button class="btn btn-success">Save Changes</button>
        <a href="index.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php require_once '../includes/footer.php'; ?>
