<?php
// modules/suppliers/delete_supplier.php
session_start();
require_once '../assets/db_connect.php';

// role guard
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
    echo json_encode(['status'=>'error','message'=>'Access denied']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

$id = intval($_POST['id'] ?? 0);
if (!$id) {
    header('Location: index.php?error=1');
    exit;
}

// Check references in product_batches and purchases
$stmt = $pdo->prepare("SELECT COUNT(*) FROM product_batches WHERE supplier_id = ?");
$stmt->execute([$id]);
$countBatches = $stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT COUNT(*) FROM purchases WHERE supplier_id = ?");
$stmt->execute([$id]);
$countPurchases = $stmt->fetchColumn();

if ($countBatches > 0 || $countPurchases > 0) {
    // safe-block deletion
    $_SESSION['flash'] = "Cannot delete supplier: linked to {$countPurchases} purchases and {$countBatches} batches.";
    header("Location: index.php?delete_error=1");
    exit;
}

// perform delete
$del = $pdo->prepare("DELETE FROM suppliers WHERE id = ?");
$del->execute([$id]);

header("Location: index.php?deleted=1");
exit;
