<?php
require '../assets/db_connect.php';

$query   = trim($_POST['query'] ?? '');
$shop_id = intval($_POST['shop_id'] ?? 0);

if ($query === '' || $shop_id <= 0) {
    echo '';
    exit;
}

// Fetch matching products only from the current shop
$stmt = $pdo->prepare("
    SELECT id, name 
    FROM products 
    WHERE shop_id = ? AND name LIKE ? 
    ORDER BY name 
    LIMIT 10
");
$stmt->execute([$shop_id, "%$query%"]);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$products) {
    echo '<div class="list-group-item">No products found</div>';
    exit;
}

// Output list items
foreach ($products as $p) {
    echo '<a href="javascript:void(0);" class="list-group-item list-group-item-action product-item" data-id="'.$p['id'].'">'.htmlspecialchars($p['name']).'</a>';
}
