<?php
session_start();
require '../assets/db_connect.php';

// Get POST data
$shop_id       = intval($_POST['shop_id'] ?? 0);
$customer_name = $_POST['customer_name'] ?? null;
$paid          = floatval($_POST['paid'] ?? 0);
$items         = $_POST['items'] ?? [];

$user_id = $_SESSION['user_id'] ?? 1; // logged-in user

if (!$shop_id) {
    echo json_encode(['status'=>'error','message'=>'Shop not selected']);
    exit;
}

if (!$items) {
    echo json_encode(['status'=>'error','message'=>'No items added']);
    exit;
}

try {
    $pdo->beginTransaction();

    // ===== Generate next invoice number safely =====
    $datePart = date('Ymd');
    $stmt = $pdo->prepare("SELECT invoice_no FROM sales WHERE invoice_no LIKE ? AND shop_id = ? ORDER BY id DESC LIMIT 1");
    $stmt->execute(["INV-{$datePart}-%", $shop_id]);
    $last_invoice = $stmt->fetchColumn();

    if ($last_invoice && preg_match('/INV-(\d{8})-(\d+)/', $last_invoice, $matches)) {
        $nextNumber = str_pad($matches[2]+1, 3, '0', STR_PAD_LEFT);
    } else {
        $nextNumber = '001';
    }
    $invoice_no = "INV-{$datePart}-{$nextNumber}";

    // Calculate total
    $total = 0;
    foreach($items as $it){
        $total += ($it['qty'] * $it['unit_price']) - $it['discount'];
    }

    // Insert sale
    $stmtSale = $pdo->prepare("
        INSERT INTO sales (invoice_no, shop_id, customer_id, total, paid, status, created_by) 
        VALUES (?, ?, NULL, ?, ?, 'open', ?)
    ");
    $stmtSale->execute([$invoice_no, $shop_id, $total, $paid, $user_id]);
    $sale_id = $pdo->lastInsertId();

    // Insert sale lines
    $stmtLine = $pdo->prepare("
        INSERT INTO sale_lines (sale_id, product_id, batch_id, qty, unit_price, discount, line_total) 
        VALUES (?,?,?,?,?,?,?)
    ");
    foreach($items as $it){
        $line_total = ($it['qty']*$it['unit_price']) - $it['discount'];
        $stmtLine->execute([$sale_id, $it['product_id'], $it['batch_id'], $it['qty'], $it['unit_price'], $it['discount'], $line_total]);

        // reduce batch qty
        $stmtBatch = $pdo->prepare("UPDATE product_batches SET qty = qty - ? WHERE id=? AND shop_id=?");
        $stmtBatch->execute([$it['qty'], $it['batch_id'], $shop_id]);
    }

    $pdo->commit();

    echo json_encode([
        'status' => 'success',
        'sale_id' => $sale_id,
        'invoice_no' => $invoice_no
    ]);

} catch(Exception $e){
    $pdo->rollBack();
    echo json_encode(['status'=>'error','message'=>$e->getMessage()]);
}
