<?php
session_start();
require '../assets/db_connect.php';

$shop_id = $_SESSION['user']['shop_id'] ?? 0;
if ($shop_id == 0) {
    echo json_encode([
        'html' => "<tr><td colspan='10'>Shop session missing.</td></tr>",
        'total_sales' => 0,
        'total_paid' => 0
    ]);
    exit;
}

$from_date = $_POST['from_date'] ?? '';
$to_date   = $_POST['to_date'] ?? '';

if (!$from_date || !$to_date) {
    echo json_encode(['html' => "<tr><td colspan='10'>Please select a valid date range.</td></tr>",
        'total_sales'=>0,
        'total_paid'=>0
    ]);
    exit;
}

/* ---------------------------------------------------------
   1. Fetch sales that belong to the active shop
--------------------------------------------------------- */
$stmt = $pdo->prepare("
    SELECT s.*, 
           c.name AS customer_name, 
           u.username AS created_by_name
    FROM sales s
    LEFT JOIN customers c ON s.customer_id = c.id
    LEFT JOIN users u ON s.created_by = u.id
    WHERE s.shop_id = ? 
      AND date(s.sale_date) BETWEEN ? AND ?
    ORDER BY s.sale_date DESC
");
$stmt->execute([$shop_id, $from_date, $to_date]);
$sales = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$sales) {
    echo json_encode([
        'html' => "<tr><td colspan='10'>No sales found in this period.</td></tr>",
        'total_sales'=>0,
        'total_paid'=>0
    ]);
    exit;
}

$html = '';
$total_sales = 0;
$total_paid = 0;

/* ---------------------------------------------------------
   2. For each sale, fetch ONLY shop-aware sale lines
--------------------------------------------------------- */
foreach ($sales as $s) {

    $prodStmt = $pdo->prepare("
        SELECT p.name AS product_name, sl.qty
        FROM sale_lines sl
        INNER JOIN product_batches pb ON sl.batch_id = pb.id AND pb.shop_id = ?
        INNER JOIN products p ON pb.product_id = p.id AND p.shop_id = ?
        WHERE sl.sale_id = ?
    ");
    $prodStmt->execute([$shop_id, $shop_id, $s['id']]);
    $products = $prodStmt->fetchAll(PDO::FETCH_ASSOC);

    $prod_list = [];
    foreach ($products as $p) {
        $prod_list[] = htmlspecialchars($p['product_name']) . " (" . $p['qty'] . ")";
    }
    $prod_str = implode(", ", $prod_list);

    // Totals
    $total_sales += $s['total'];
    $total_paid += $s['paid'];

    $html .= "<tr id='row-{$s['id']}'>
        <td>{$s['id']}</td>
        <td>" . htmlspecialchars($s['invoice_no']) . "</td>
        <td>" . date('d-M-Y H:i', strtotime($s['sale_date'])) . "</td>
        <td>" . htmlspecialchars($s['customer_name'] ?? '-') . "</td>
        <td>{$prod_str}</td>
        <td>" . number_format($s['total'], 2) . "</td>
        <td>" . number_format($s['paid'], 2) . "</td>
        <td>" . htmlspecialchars($s['status']) . "</td>
        <td>" . htmlspecialchars($s['created_by_name'] ?? '-') . "</td>

        <td class='no-print'>
            <a href='view_sale.php?id={$s['id']}' class='btn btn-sm btn-info'>View</a>
            <a href='edit_sale.php?id={$s['id']}' class='btn btn-sm btn-warning'>Edit</a>
            <button class='btn btn-sm btn-danger' onclick='deleteSale({$s['id']})'>Delete</button>
        </td>
    </tr>";
}

echo json_encode([
    'html' => $html,
    'total_sales' => $total_sales,
    'total_paid' => $total_paid
]);

