<?php
// modules/sales/list_sales.php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

$shop_id = $_SESSION['user']['shop_id'] ?? 0;
if ($shop_id == 0) {
    die("Shop session missing.");
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="text-success">Sales</h3>
        <a href="add_sale.php" class="btn btn-primary no-print">+ Add Sale</a>
    </div>

    <!-- Date filter form -->
    <form id="filterForm" class="form-inline mb-3 no-print">
        <label class="mr-2">From:</label>
        <input type="date" name="from_date" class="form-control mr-3" required>

        <label class="mr-2">To:</label>
        <input type="date" name="to_date" class="form-control mr-3" required>

        <button type="submit" class="btn btn-success">Filter</button>
        <button type="button" class="btn btn-secondary ml-2" onclick="window.print()">Print</button>
    </form>

    <div class="table-responsive">
        <table class="table table-bordered table-hover" id="salesTable">
            <thead class="thead-light">
                <tr>
                    <th>ID</th>
                    <th>Invoice</th>
                    <th>Date</th>
                    <th>Customer</th>
                    <th>Products</th>
                    <th>Total</th>
                    <th>Paid</th>
                    <th>Status</th>
                    <th>Created By</th>
                    <th class="no-print">Actions</th>
                </tr>
            </thead>
            <tbody id="salesBody">
                <tr><td colspan="10" class="text-center">Please select date range and click Filter</td></tr>
            </tbody>
            <tfoot id="salesFoot"></tfoot>
        </table>
    </div>
</div>

<style>
@media print {
    .no-print { display: none !important; }
    table { page-break-inside: auto; }
    tr { page-break-inside: avoid; page-break-after: auto; }
}
</style>

<script>
document.getElementById('filterForm').addEventListener('submit', function(e){
    e.preventDefault();
    const formData = new FormData(this);

    fetch('load_sales.php', {
        method: 'POST',
        body: formData
    })
    .then(res => res.json())
    .then(data => {

        // If no results
        if (data.count === 0) {
            document.getElementById('salesBody').innerHTML =
                `<tr><td colspan="10" class="text-center text-danger">No Sales Found for selected dates</td></tr>`;

            document.getElementById('salesFoot').innerHTML = "";
            return;
        }

        // Populate table rows
        document.getElementById('salesBody').innerHTML = data.html;

        // Totals row
        document.getElementById('salesFoot').innerHTML = `
            <tr>
                <th colspan="5" class="text-right">TOTAL:</th>
                <th>${Number(data.total_sales).toFixed(2)}</th>
                <th>${Number(data.total_paid).toFixed(2)}</th>
                <th colspan="3"></th>
            </tr>`;
    })
    .catch(err => console.error(err));
});

// Delete sale function
function deleteSale(id) {
    if (!confirm("Delete this sale? This will restore stock levels.")) return;

    fetch('delete_sale.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'id=' + id
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'success') {
            const row = document.getElementById('row-' + id);
            if (row) row.remove();
            alert(data.message);
        } else {
            alert(data.message);
        }
    })
    .catch(err => {
        console.error(err);
        alert("Error deleting sale.");
    });
}
</script>

<?php require_once '../includes/footer.php'; ?>
