<?php
require '../assets/db_connect.php';

$product_id = intval($_POST['product_id'] ?? 0);
$shop_id    = intval($_POST['shop_id'] ?? 0);

if (!$product_id || !$shop_id) {
    echo json_encode(['status'=>'error','message'=>'Invalid product or shop']);
    exit;
}

// Fetch first available batch in this shop with stock
$stmt = $pdo->prepare("
    SELECT id AS batch_id, batch_no, qty, sell_price AS price, expiry_date
    FROM product_batches
    WHERE product_id = ? AND shop_id = ? AND qty > 0
    ORDER BY expiry_date ASC
    LIMIT 1
");
$stmt->execute([$product_id, $shop_id]);
$batch = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$batch) {
    echo json_encode(['status'=>'error','message'=>'No available batches in this shop']);
    exit;
}

// Return JSON
echo json_encode([
    'status'   => 'success',
    'batch_id' => $batch['batch_id'],
    'batch_no' => $batch['batch_no'],
    'qty'      => $batch['qty'],
    'price'    => $batch['price'],
    'expiry'   => $batch['expiry_date']
]);
