<?php
// modules/sales/ajax_get_batch_price.php
header('Content-Type: application/json');
require_once '../assets/db_connect.php'; // <- adjust path if needed

if (!isset($_POST['batch_id']) || empty($_POST['batch_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Batch ID missing']);
    exit;
}

$batch_id = intval($_POST['batch_id']);

try {
    $stmt = $pdo->prepare("SELECT id, sell_price, qty, expiry_date FROM product_batches WHERE id = :id");
    $stmt->execute([':id' => $batch_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        echo json_encode(['status' => 'error', 'message' => 'Batch not found']);
        exit;
    }

    echo json_encode([
        'status' => 'success',
        'batch_id' => (int)$row['id'],
        'sell_price' => number_format((float)$row['sell_price'], 2, '.', ''),
        'qty_available' => (int)$row['qty'],
        'expiry_date' => $row['expiry_date']
    ]);

} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
