<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$sql = "
 SELECT s.id, s.name, COUNT(p.id) AS invoices, COALESCE(SUM(p.total),0) AS total_supplied
 FROM suppliers s
 LEFT JOIN purchases p ON p.supplier_id = s.id
 GROUP BY s.id
 ORDER BY total_supplied DESC
";
$rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
<h3 class="text-success">Supplier Purchase Summary</h3>

<table class="table table-sm table-bordered">
<thead><tr><th>#</th><th>Supplier</th><th>Invoices</th><th>Total Supplied</th></tr></thead>
<tbody>
<?php foreach($rows as $r): ?>
<tr><td><?= $r['id'] ?></td><td><?= htmlspecialchars($r['name']) ?></td><td><?= $r['invoices'] ?></td><td><?= number_format($r['total_supplied'],2) ?></td></tr>
<?php endforeach; ?>
</tbody>
</table>
</div>

<?php require_once '../includes/footer.php'; ?>
