<?php session_start();
include('../includes/header.php'); 
include('../includes/sidebar.php'); 
include('../assets/db_connect.php');



// Allow only admins
if (!isset($_SESSION['user']) || $_SESSION['user']['role'] != 'admin') {
    die("Access denied. Admin only.");
}

// Default date range: last 30 days
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-d', strtotime('-30 days'));
$end_date   = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');

// Fetch supplier ID if provided
$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;

// Prepare SQL
$sql = "
    SELECT 
        s.name AS supplier_name,
        p.name AS product_name,
        pb.batch_no,
        pl.qty,
        pl.cost_price,
        pl.qty * pl.cost_price AS line_total,
        pu.invoice_no,
        pu.purchase_date
    FROM purchase_lines pl
    JOIN product_batches pb ON pb.id = pl.batch_id
    JOIN products p ON p.id = pb.product_id
    JOIN purchases pu ON pu.id = pl.purchase_id
    JOIN suppliers s ON s.id = pu.supplier_id
    WHERE pu.purchase_date BETWEEN :start_date AND :end_date
";

if ($supplier_id > 0) {
    $sql .= " AND s.id = :supplier_id";
}

$sql .= " ORDER BY pu.purchase_date ASC";

$stmt = $pdo->prepare($sql);
$stmt->bindParam(':start_date', $start_date);
$stmt->bindParam(':end_date', $end_date);
if ($supplier_id > 0) {
    $stmt->bindParam(':supplier_id', $supplier_id, PDO::PARAM_INT);
}
$stmt->execute();
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="content-wrapper">
    <div class="container-fluid mt-3">
        <div class="card">
            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Supplier Statement</h5>
                <button class="btn btn-light btn-sm" onclick="window.print()">Print</button>
            </div>
            <div class="card-body">
                
                <form class="form-inline mb-3">
                    <label class="mr-2">Start Date:</label>
                    <input type="date" name="start_date" class="form-control mr-3" value="<?= $start_date ?>">
                    <label class="mr-2">End Date:</label>
                    <input type="date" name="end_date" class="form-control mr-3" value="<?= $end_date ?>">
                    <label class="mr-2">Supplier:</label>
                    <select name="supplier_id" class="form-control mr-2">
                        <option value="0">All Suppliers</option>
                        <?php
                        $suppliers = $pdo->query("SELECT * FROM suppliers ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($suppliers as $s) {
                            $selected = ($s['id'] == $supplier_id) ? "selected" : "";
                            echo "<option value='{$s['id']}' $selected>{$s['name']}</option>";
                        }
                        ?>
                    </select>
                    <button type="submit" class="btn btn-primary btn-sm">Filter</button>
                </form>

                <table class="table table-bordered table-hover table-sm">
                    <thead class="thead-dark">
                        <tr>
                            <th>#</th>
                            <th>Supplier</th>
                            <th>Product</th>
                            <th>Batch No</th>
                            <th>Qty</th>
                            <th>Cost Price</th>
                            <th>Line Total</th>
                            <th>Invoice No</th>
                            <th>Purchase Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!$data): ?>
                            <tr>
                                <td colspan="9" class="text-center text-muted">No purchases found for this range.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($data as $i => $row): ?>
                                <tr>
                                    <td><?= $i + 1 ?></td>
                                    <td><?= htmlspecialchars($row['supplier_name']) ?></td>
                                    <td><?= htmlspecialchars($row['product_name']) ?></td>
                                    <td><?= htmlspecialchars($row['batch_no']) ?></td>
                                    <td><?= $row['qty'] ?></td>
                                    <td><?= number_format($row['cost_price'],2) ?></td>
                                    <td><?= number_format($row['line_total'],2) ?></td>
                                    <td><?= htmlspecialchars($row['invoice_no']) ?></td>
                                    <td><?= date('Y-m-d', strtotime($row['purchase_date'])) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>

            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
