<?php
include('../includes/header.php'); 
include('../includes/sidebar.php'); 
require '../assets/db_connect.php';

// HARD-CODED LOW STOCK THRESHOLD
$threshold = 20;

// Query
$sql = "
    SELECT 
        p.id,
        p.name,
        p.sku,
        COALESCE(SUM(b.qty), 0) AS total_qty
    FROM products p
    LEFT JOIN product_batches b 
        ON p.id = b.product_id AND b.is_active = 1
    GROUP BY p.id
    HAVING total_qty <= :threshold
    ORDER BY total_qty ASC
";
$stmt = $pdo->prepare($sql);
$stmt->execute(['threshold' => $threshold]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!-- PAGE CONTENT WRAPPER -->
<div class="col-md-10 ml-sm-auto px-4 py-4">

    <div class="card mt-3">
        <div class="card-header bg-danger text-white">
            <h5 class="mb-0">Low Stock Products (Below <?= $threshold ?> Units)</h5>
        </div>

        <div class="card-body">
            <table class="table table-bordered table-sm">
                <thead class="thead-dark">
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>SKU</th>
                        <th>Available Qty</th>
                    </tr>
                </thead>
                <tbody>
                <?php if ($rows): 
                    $sn = 1;
                    foreach ($rows as $row): ?>
                        <tr>
                            <td><?= $sn++ ?></td>
                            <td><?= htmlspecialchars($row['name']) ?></td>
                            <td><?= htmlspecialchars($row['sku']) ?></td>
                            <td class="<?= ($row['total_qty'] <= 0 ? 'bg-danger text-white' : 'bg-warning'); ?>">
                                <?= $row['total_qty'] ?>
                            </td>
                        </tr>
                <?php endforeach; else: ?>
                        <tr>
                            <td colspan="4" class="text-center text-muted">No low stock products.</td>
                        </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<?php include('../includes/footer.php'); ?>
