<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');

$sql = "
 SELECT p.*, s.name AS supplier_name
 FROM purchases p
 LEFT JOIN suppliers s ON s.id = p.supplier_id
 WHERE p.purchase_date BETWEEN ? AND ?
 ORDER BY p.purchase_date DESC
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$from,$to]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
<h3 class="text-success">Purchases Between Dates</h3>
<form class="form-inline mb-3">
  <input type="date" name="from" value="<?= $from ?>" class="form-control mr-2">
  <input type="date" name="to" value="<?= $to ?>" class="form-control mr-2">
  <button class="btn btn-primary">Filter</button>
  <a href="?from=<?= $from ?>&to=<?= $to ?>&export=csv" class="btn btn-outline-secondary ml-2">Export CSV</a>
</form>

<table class="table table-bordered">
<thead><tr><th>ID</th><th>Invoice</th><th>Date</th><th>Supplier</th><th>Total</th></tr></thead>
<tbody>
<?php foreach($rows as $r): ?>
  <tr>
    <td><?= $r['id'] ?></td>
    <td><?= htmlspecialchars($r['invoice_no']) ?></td>
    <td><?= $r['purchase_date'] ?></td>
    <td><?= htmlspecialchars($r['supplier_name']) ?></td>
    <td><?= number_format($r['total'],2) ?></td>
  </tr>
<?php endforeach; ?>
</tbody>
</table>
</div>

<?php require_once '../includes/footer.php'; ?>
