<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

if (!isset($_GET['id'])) {
    die("<div class='alert alert-danger'>Invalid purchase ID.</div>");
}

$purchase_id = intval($_GET['id']);
$shop_id = $_SESSION['user']['shop_id'];

// Fetch purchase header
$stmt = $pdo->prepare("
    SELECT p.*, s.name AS supplier_name, u.username AS created_by_name
    FROM purchases p
    LEFT JOIN suppliers s ON p.supplier_id = s.id
    LEFT JOIN users u ON p.created_by = u.id
    WHERE p.id = ? AND p.shop_id = ?
");
$stmt->execute([$purchase_id, $shop_id]);
$purchase = $stmt->fetch();

if (!$purchase) {
    die("<div class='alert alert-danger'>Purchase not found.</div>");
}

// Fetch line items
$stmtLines = $pdo->prepare("
    SELECT pl.*, 
           (pl.qty * pl.cost_price) AS line_total,
           pb.batch_no,
           pb.expiry_date,
           p.name AS product_name
    FROM purchase_lines pl
    LEFT JOIN product_batches pb ON pl.batch_id = pb.id
    LEFT JOIN products p ON pb.product_id = p.id
    WHERE pl.purchase_id = ?
");
$stmtLines->execute([$purchase_id]);
$lines = $stmtLines->fetchAll();
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <h3 class="text-success mb-4">View Purchase #<?= $purchase['id'] ?></h3>

    <div class="card mb-4">
        <div class="card-body">
            <p><strong>Supplier:</strong> <?= htmlspecialchars($purchase['supplier_name']) ?></p>
            <p><strong>Invoice No:</strong> <?= htmlspecialchars($purchase['invoice_no']) ?></p>
            <p><strong>Date:</strong> <?= date('d-M-Y', strtotime($purchase['purchase_date'])) ?></p>
            <p><strong>Total:</strong> <span class="badge badge-success">
                <?= number_format($purchase['total'], 2) ?>
            </span></p>
            <p><strong>Created By:</strong> <?= htmlspecialchars($purchase['created_by_name']) ?></p>
        </div>
    </div>

    <h5 class="mb-3">Purchase Items</h5>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Product</th>
                <th>Batch No</th>
                <th>Expiry</th>
                <th>Qty</th>
                <th>Cost Price</th>
                <th>Line Total</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($lines)): ?>
                <tr><td colspan="6" class="text-center text-muted">No items found.</td></tr>
            <?php else: ?>
                <?php foreach ($lines as $ln): ?>
                <tr>
                    <td><?= htmlspecialchars($ln['product_name']) ?></td>
                    <td><?= htmlspecialchars($ln['batch_no']) ?></td>
                    <td><?= $ln['expiry_date'] ? date('d-M-Y', strtotime($ln['expiry_date'])) : '-' ?></td>
                    <td><?= $ln['qty'] ?></td>
                    <td><?= number_format($ln['cost_price'], 2) ?></td>
                    <td><?= number_format($ln['line_total'], 2) ?></td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <a href="list_purchases.php" class="btn btn-secondary mt-3">Back</a>
</div>

<?php require_once '../includes/footer.php'; ?>
