<?php
session_start();
require '../assets/db_connect.php';

header('Content-Type: application/json');

// Ensure user and shop are set
$shop_id = $_SESSION['user']['shop_id'] ?? 0;
$created_by = $_SESSION['user']['id'] ?? 0;

if ($shop_id == 0 || $created_by == 0) {
    echo json_encode(['status'=>'error', 'message'=>'Shop or user session missing']);
    exit;
}

// Basic purchase info
$supplier_id   = intval($_POST['supplier_id'] ?? 0);
$invoice_no    = trim($_POST['invoice_no'] ?? '');
$purchase_date = $_POST['purchase_date'] ?? date('Y-m-d');

// Purchase items arrays
$product_ids   = $_POST['product_id'] ?? [];
$batch_nos     = $_POST['batch_no'] ?? [];
$qtys          = $_POST['qty'] ?? [];
$cost_prices   = $_POST['cost_price'] ?? [];
$sell_prices   = $_POST['sell_price'] ?? [];
$expiry_dates  = $_POST['expiry_date'] ?? [];

if ($supplier_id == 0 || empty($invoice_no) || empty($product_ids)) {
    echo json_encode(['status'=>'error', 'message'=>'Please fill all required fields']);
    exit;
}

// ------------------------
// 1. INSERT INTO purchases
// ------------------------
$stmt = $pdo->prepare("INSERT INTO purchases (supplier_id, invoice_no, purchase_date, created_by, shop_id) VALUES (?, ?, ?, ?, ?)");
$stmt->execute([$supplier_id, $invoice_no, $purchase_date, $created_by, $shop_id]);

$purchase_id = $pdo->lastInsertId();

// ------------------------
// 2. INSERT PURCHASE LINES
// ------------------------
$total = 0;

for ($i=0; $i < count($product_ids); $i++) {
    $pid   = intval($product_ids[$i]);
    $batch = trim($batch_nos[$i]);
    $qty   = intval($qtys[$i]);
    $cost  = floatval($cost_prices[$i]);
    $sell  = floatval($sell_prices[$i]);
    $exp   = $expiry_dates[$i] ?? null;

    if ($pid == 0 || $qty <= 0 || $cost <= 0) continue;

    // Create product batch
    $batchStmt = $pdo->prepare("INSERT INTO product_batches 
        (product_id, batch_no, qty, cost_price, sell_price, expiry_date, created_by, shop_id)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $batchStmt->execute([$pid, $batch, $qty, $cost, $sell, $exp, $created_by, $shop_id]);
    $batch_id = $pdo->lastInsertId();

    // Insert purchase line
    $lineStmt = $pdo->prepare("INSERT INTO purchase_lines (purchase_id, batch_id, qty, cost_price) VALUES (?, ?, ?, ?)");
    $lineStmt->execute([$purchase_id, $batch_id, $qty, $cost]);

    $total += $qty * $cost;
}

// ------------------------
// 3. UPDATE PURCHASE TOTAL
// ------------------------
$update = $pdo->prepare("UPDATE purchases SET total=? WHERE id=?");
$update->execute([$total, $purchase_id]);

echo json_encode(['status'=>'success', 'message'=>'Purchase saved successfully!']);
