<?php
session_start();
require '../assets/db_connect.php';

// -------------------------
// 1. VALIDATE INPUT
// -------------------------
if (!isset($_POST['purchase_id']) || !isset($_SESSION['user'])) {
    die("Invalid request or session expired");
}

$purchase_id   = intval($_POST['purchase_id']);
$supplier_id   = intval($_POST['supplier_id']);
$invoice_no    = trim($_POST['invoice_no']);
$purchase_date = $_POST['purchase_date'];
$shop_id       = $_SESSION['user']['shop_id'] ?? 0;

if ($shop_id == 0) die("Shop session missing");

// Arrays for purchase lines
$line_ids     = $_POST['line_id'] ?? [];
$batch_ids    = $_POST['batch_id'] ?? [];
$qtys         = $_POST['qty'] ?? [];
$cost_prices  = $_POST['cost_price'] ?? [];

// -------------------------
// 2. UPDATE MAIN PURCHASE
// -------------------------
$update_purchase = $pdo->prepare("
    UPDATE purchases 
    SET supplier_id=?, invoice_no=?, purchase_date=?, shop_id=?
    WHERE id=?
");
$update_purchase->execute([$supplier_id, $invoice_no, $purchase_date, $shop_id, $purchase_id]);

// -------------------------
// 3. GET EXISTING LINES
// -------------------------
$existing_lines_stmt = $pdo->prepare("SELECT id FROM purchase_lines WHERE purchase_id=?");
$existing_lines_stmt->execute([$purchase_id]);
$existing_lines = $existing_lines_stmt->fetchAll(PDO::FETCH_COLUMN, 0);

$updated_lines = [];
$total = 0;

// -------------------------
// 4. LOOP THROUGH SUBMITTED LINES
// -------------------------
for ($i = 0; $i < count($batch_ids); $i++) {
    $line_id = intval($line_ids[$i]);
    $batch_id = intval($batch_ids[$i]);
    $qty = intval($qtys[$i]);
    $cost = floatval($cost_prices[$i]);

    if ($batch_id <= 0 || $qty <= 0 || $cost <= 0) continue;

    $total += $qty * $cost;

    if ($line_id > 0 && in_array($line_id, $existing_lines)) {
        // UPDATE existing line
        $stmt = $pdo->prepare("
            UPDATE purchase_lines
            SET batch_id=?, qty=?, cost_price=?
            WHERE id=? AND purchase_id=?
        ");
        $stmt->execute([$batch_id, $qty, $cost, $line_id, $purchase_id]);
        $updated_lines[] = $line_id;
    } else {
        // INSERT new line
        $stmt = $pdo->prepare("
            INSERT INTO purchase_lines (purchase_id, batch_id, qty, cost_price)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->execute([$purchase_id, $batch_id, $qty, $cost]);
        $updated_lines[] = $pdo->lastInsertId();
    }
}

// -------------------------
// 5. DELETE REMOVED LINES
// -------------------------
foreach ($existing_lines as $existing_id) {
    if (!in_array($existing_id, $updated_lines)) {
        $del_stmt = $pdo->prepare("DELETE FROM purchase_lines WHERE id=? AND purchase_id=?");
        $del_stmt->execute([$existing_id, $purchase_id]);
    }
}

// -------------------------
// 6. UPDATE PURCHASE TOTAL
// -------------------------
$update_total = $pdo->prepare("UPDATE purchases SET total=? WHERE id=?");
$update_total->execute([$total, $purchase_id]);

// -------------------------
// 7. REDIRECT BACK
// -------------------------
header("Location: view_purchase.php?id=" . $purchase_id);
exit;
