<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

// Ensure user and shop session
if (!isset($_SESSION['user']['id'], $_SESSION['user']['shop_id'])) {
    header("Location: ../../auth/login.php");
    exit();
}

$shop_id = $_SESSION['user']['shop_id'];

// Validate purchase ID
$purchase_id = intval($_GET['id'] ?? 0);
if ($purchase_id <= 0) {
    die("Invalid purchase ID");
}

// Fetch purchase
$stmt = $pdo->prepare("SELECT * FROM purchases WHERE id=? AND shop_id=?");
$stmt->execute([$purchase_id, $shop_id]);
$purchase = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$purchase) die("Purchase not found or not authorized");

// Fetch suppliers
$suppliers = $pdo->query("SELECT id, name FROM suppliers ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// Fetch purchase lines with product and batch info
$lines_stmt = $pdo->prepare("
    SELECT pl.id AS line_id, pl.batch_id, pl.qty, pl.cost_price,
           pb.product_id, pb.batch_no, p.name AS product_name
    FROM purchase_lines pl
    LEFT JOIN product_batches pb ON pl.batch_id = pb.id
    LEFT JOIN products p ON pb.product_id = p.id
    WHERE pl.purchase_id=?
");
$lines_stmt->execute([$purchase_id]);
$purchase_lines = $lines_stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch products for adding new rows
$products = $pdo->query("SELECT id, name FROM products ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <h3 class="text-success mb-4">Edit Purchase #<?= $purchase['id'] ?></h3>

    <form id="editPurchaseForm" method="POST" action="save_edit_purchase.php">
        <input type="hidden" name="purchase_id" value="<?= $purchase['id'] ?>">

        <div class="row mb-3">
            <div class="col-md-4">
                <label>Supplier</label>
                <select name="supplier_id" class="form-control" required>
                    <option value="">Select Supplier</option>
                    <?php foreach ($suppliers as $s): ?>
                        <option value="<?= $s['id'] ?>" <?= $s['id']==$purchase['supplier_id']?'selected':'' ?>>
                            <?= htmlspecialchars($s['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-4">
                <label>Invoice No</label>
                <input type="text" name="invoice_no" class="form-control" required 
                       value="<?= htmlspecialchars($purchase['invoice_no']) ?>">
            </div>

            <div class="col-md-4">
                <label>Purchase Date</label>
                <input type="date" name="purchase_date" class="form-control" required
                       value="<?= $purchase['purchase_date'] ?>">
            </div>
        </div>

        <h5>Items</h5>
        <table class="table table-bordered" id="linesTable">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Batch No</th>
                    <th>Qty</th>
                    <th>Cost Price</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($purchase_lines as $line): ?>
                <tr>
                    <td>
                        <input type="text" class="form-control" value="<?= htmlspecialchars($line['product_name']) ?>" disabled>
                        <input type="hidden" name="product_id[]" value="<?= $line['product_id'] ?>">
                    </td>
                    <td>
                        <input type="hidden" name="batch_id[]" value="<?= $line['batch_id'] ?>">
                        <input type="text" class="form-control" value="<?= htmlspecialchars($line['batch_no']) ?>" disabled>
                    </td>
                    <td>
                        <input type="number" class="form-control qty" name="qty[]" value="<?= $line['qty'] ?>" min="1" required>
                        <input type="hidden" name="line_id[]" value="<?= $line['line_id'] ?>">
                    </td>
                    <td>
                        <input type="number" class="form-control cost" name="cost_price[]" value="<?= $line['cost_price'] ?>" step="0.01" required>
                    </td>
                    <td>
                        <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">X</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="mb-3">
            <label><strong>Total</strong></label>
            <input type="text" id="total" class="form-control" readonly value="<?= $purchase['total'] ?>">
        </div>

        <button type="submit" class="btn btn-success">Save Changes</button>
    </form>
</div>

<script>
function removeRow(btn) {
    btn.closest("tr").remove();
    calculateTotal();
}

function calculateTotal() {
    let total = 0;
    document.querySelectorAll("#linesTable tbody tr").forEach(row => {
        let qty = parseFloat(row.querySelector(".qty")?.value) || 0;
        let cost = parseFloat(row.querySelector(".cost")?.value) || 0;
        total += qty * cost;
    });
    document.getElementById("total").value = total.toFixed(2);
}

document.addEventListener("input", function(e) {
    if (e.target.classList.contains("qty") || e.target.classList.contains("cost")) {
        calculateTotal();
    }
});
</script>

<?php require_once '../includes/footer.php'; ?>
