<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

// Ensure session has shop assigned
if (!isset($_SESSION['user']['shop_id'])) {
    die("Shop not assigned. Please contact admin.");
}
$shop_id = $_SESSION['user']['shop_id'];

// Fetch suppliers (global)
$supplierStmt = $pdo->query("SELECT id, name FROM suppliers ORDER BY name");
$suppliers = $supplierStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch products (you could filter by shop if needed)
$productStmt = $pdo->query("SELECT id, name FROM products WHERE shop_id = $shop_id ORDER BY name");
$products = $productStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <h3 class="text-success mb-4">New Purchase</h3>

    <form id="purchaseForm">
        <input type="hidden" name="shop_id" value="<?= $shop_id ?>"> <!-- optional -->
        <div class="row">
            <div class="col-md-4 mb-3">
                <label>Supplier</label>
                <select name="supplier_id" class="form-control" required>
                    <option value="">Select Supplier</option>
                    <?php foreach ($suppliers as $s): ?>
                        <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-4 mb-3">
                <label>Invoice No</label>
                <input type="text" name="invoice_no" class="form-control" required>
            </div>

            <div class="col-md-4 mb-3">
                <label>Purchase Date</label>
                <input type="date" name="purchase_date" class="form-control" required>
            </div>
        </div>

        <hr>

        <h5>Items</h5>
        <table class="table table-bordered" id="itemsTable">
            <thead>
                <tr>
                    <th>Product</th>
                    <th>Batch No</th>
                    <th>Qty</th>
                    <th>Cost Price</th>
                    <th>Sell Price</th>
                    <th>Expiry</th>
                    <th></th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>

        <button type="button" class="btn btn-info mb-3" onclick="addRow()">+ Add Item</button>

        <div class="mb-3">
            <label><strong>Total</strong></label>
            <input type="text" id="total" class="form-control" readonly>
        </div>

        <button type="submit" class="btn btn-success">Save Purchase</button>
    </form>
</div>

<script>
const products = <?= json_encode($products) ?>;

function addRow() {
    let row = `
    <tr>
        <td>
            <select name="product_id[]" class="form-control" required>
                <option value="">Select</option>
                ${products.map(p => `<option value="${p.id}">${p.name}</option>`).join('')}
            </select>
        </td>
        <td><input type="text" name="batch_no[]" class="form-control" required></td>
        <td><input type="number" name="qty[]" class="form-control qty" min="1" required></td>
        <td><input type="number" name="cost_price[]" class="form-control cost" step="0.01" required></td>
        <td><input type="number" name="sell_price[]" class="form-control" step="0.01" required></td>
        <td><input type="date" name="expiry_date[]" class="form-control"></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">X</button></td>
    </tr>`;
    document.querySelector("#itemsTable tbody").insertAdjacentHTML("beforeend", row);
}

function removeRow(btn) {
    btn.closest("tr").remove();
    calculateTotal();
}

document.addEventListener("input", function(e) {
    if (e.target.classList.contains("qty") || e.target.classList.contains("cost")) {
        calculateTotal();
    }
});

function calculateTotal() {
    let total = 0;
    document.querySelectorAll("#itemsTable tbody tr").forEach(row => {
        let qty = parseFloat(row.querySelector(".qty")?.value) || 0;
        let cost = parseFloat(row.querySelector(".cost")?.value) || 0;
        total += qty * cost;
    });
    document.getElementById("total").value = total.toFixed(2);
}

// Submit form
document.getElementById("purchaseForm").addEventListener("submit", function(e) {
    e.preventDefault();
    let formData = new FormData(this);

    fetch("save_purchase.php", {
        method: "POST",
        body: formData
    })
    .then(r => r.json())
    .then(res => {
        alert(res.message);
        if (res.status === "success") {
            window.location.href = "list_purchases.php";
        }
    })
    .catch(err => console.error(err));
});
</script>

<?php require_once '../includes/footer.php'; ?>
