<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

if (!isset($_SESSION['user']['id']) || !isset($_SESSION['user']['shop_id'])) {
    header("Location: ../auth/login.php");
    exit();
}

$shop_id = $_SESSION['user']['shop_id'];

// Fetch products for this shop
$stmt = $pdo->prepare("SELECT * FROM products WHERE shop_id = ? ORDER BY id DESC");
$stmt->execute([$shop_id]);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="col-md-10 ml-sm-auto px-4 py-4">
    <h3 class="text-success mb-4">Products</h3>

    <div class="d-flex justify-content-between mb-3">
        <a href="add_product.php" class="btn btn-primary">+ Add New Product</a>
        <input type="text" id="searchBox" class="form-control w-25" placeholder="Search by SKU, Name, Category...">
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-hover" id="productsTable">
            <thead class="thead-light">
                <tr>
                    <th>ID</th>
                    <th>SKU</th>
                    <th>Name</th>
                    <th>Generic Name</th>
                    <th>Unit</th>
                    <th>Category</th>
                    <th>VAT %</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($products as $row): ?>
                <tr id="row-<?= $row['id'] ?>">
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['sku']) ?></td>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= htmlspecialchars($row['generic_name']) ?></td>
                    <td><?= htmlspecialchars($row['unit']) ?></td>
                    <td><?= htmlspecialchars($row['category']) ?></td>
                    <td><?= $row['vat_percent'] ?></td>
                    <td>
                        <a href="edit_product.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <button class="btn btn-danger btn-sm" onclick="deleteProduct(<?= $row['id'] ?>)">Delete</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script>
function deleteProduct(productId) {
    if (confirm("Are you sure you want to delete this product?")) {
        $.ajax({
            url: 'delete_product.php',
            type: 'POST',
            data: { id: productId },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    alert(response.message);
                    $("#row-" + productId).fadeOut(400, function() { $(this).remove(); });
                } else {
                    alert(response.message);
                }
            },
            error: function(xhr, status, error) {
                console.error("AJAX Error:", error);
                alert("An error occurred while deleting the product.");
            }
        });
    }
}

// Real-time search/filter
$('#searchBox').on('keyup', function() {
    let filter = $(this).val().toLowerCase();
    $('#productsTable tbody tr').each(function() {
        let text = $(this).text().toLowerCase();
        $(this).toggle(text.indexOf(filter) > -1);
    });
});
</script>
