<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

$message = '';

if (!isset($_GET['id'])) {
    header("Location: list_products.php");
    exit;
}

$id = $_GET['id'];

$stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
$stmt->execute([$id]);
$product = $stmt->fetch();

if (!$product) {
    echo "<div class='alert alert-danger'>Product not found.</div>";
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sku = trim($_POST['sku']);
    $name = trim($_POST['name']);
    $generic_name = trim($_POST['generic_name']);
    $unit = trim($_POST['unit']);
    $category = trim($_POST['category']);
    $vat_percent = trim($_POST['vat_percent']);

    $stmt = $pdo->prepare("UPDATE products SET sku=?, name=?, generic_name=?, unit=?, category=?, vat_percent=? WHERE id=?");
    $stmt->execute([$sku, $name, $generic_name, $unit, $category, $vat_percent, $id]);
    $message = "<div class='alert alert-success'>Product updated successfully!</div>";

    // Refresh product data
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->execute([$id]);
    $product = $stmt->fetch();
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <h3 class="text-success mb-4">Edit Product</h3>

    <?= $message ?>

    <form method="POST" action="">
        <div class="form-group mb-3">
            <label>SKU</label>
            <input type="text" name="sku" class="form-control" value="<?= htmlspecialchars($product['sku']) ?>">
        </div>
        <div class="form-group mb-3">
            <label>Product Name *</label>
            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($product['name']) ?>" required>
        </div>
        <div class="form-group mb-3">
            <label>Generic Name</label>
            <input type="text" name="generic_name" class="form-control" value="<?= htmlspecialchars($product['generic_name']) ?>">
        </div>
        <div class="form-group mb-3">
            <label>Unit</label>
            <input type="text" name="unit" class="form-control" value="<?= htmlspecialchars($product['unit']) ?>">
        </div>
        <div class="form-group mb-3">
            <label>Category</label>
            <input type="text" name="category" class="form-control" value="<?= htmlspecialchars($product['category']) ?>">
        </div>
        <div class="form-group mb-3">
            <label>VAT %</label>
            <input type="number" step="0.01" name="vat_percent" class="form-control" value="<?= htmlspecialchars($product['vat_percent']) ?>">
        </div>
        <button type="submit" class="btn btn-success">Update Product</button>
        <a href="list_products.php" class="btn btn-secondary">Back</a>
    </form>
</div>

<?php require_once '../../includes/footer.php'; ?>
