<?php
require_once '../assets/db_connect.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = intval($_POST['id']);

    try {
        // Check if product has batches
        $check = $pdo->prepare("SELECT COUNT(*) FROM product_batches WHERE product_id = :pid");
        $check->execute([':pid' => $product_id]);
        $count = $check->fetchColumn();

        if ($count > 0) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Cannot delete this product — it has existing batches.'
            ]);
            exit;
        }

        // Delete product
        $stmt = $pdo->prepare("DELETE FROM products WHERE id = :id");
        $stmt->execute([':id' => $product_id]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['status' => 'success', 'message' => 'Product deleted successfully.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Product not found.']);
        }

    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
