<?php
session_start();
require_once '../assets/db_connect.php';

if (!isset($_SESSION['user'])) {
    header("Location: ../auth/login.php");
    exit;
}

$user = $_SESSION['user'];
$shop_id = $user['shop_id'];

// Ensure id is passed
if (!isset($_GET['id']) || empty($_GET['id'])) {
    $_SESSION['message'] = ['status' => 'error', 'text' => 'Batch ID is missing'];
    header("Location: list_batches.php");
    exit;
}

$batch_id = intval($_GET['id']);

try {
    // Soft delete: set is_active = 0
    $stmt = $pdo->prepare("
        UPDATE product_batches
        SET is_active = 0, updated_by = ?, updated_at = NOW()
        WHERE id = ? AND shop_id = ?
    ");
    $stmt->execute([$user['id'], $batch_id, $shop_id]);

    if ($stmt->rowCount() > 0) {
        $_SESSION['message'] = ['status' => 'success', 'text' => 'Batch deactivated successfully'];
    } else {
        $_SESSION['message'] = ['status' => 'error', 'text' => 'Batch not found or already inactive'];
    }

} catch (PDOException $e) {
    $_SESSION['message'] = ['status' => 'error', 'text' => $e->getMessage()];
}

// Redirect back to batch list
header("Location: list_batches.php");
exit;
