<style>
    /* Sidebar styling */
    #sidebar {
        background: #ff6600; /* deep orange */
        min-height: 100vh;
        padding-top: 20px;
        transition: all 0.3s ease-in-out;
    }

    #sidebar .nav-link {
        color: #fff;
        font-weight: 500;
        padding: 10px 15px;
    }

    #sidebar .nav-link i {
        width: 20px;
    }

    #sidebar .nav-link:hover {
        background: rgba(255, 255, 255, 0.2);
        color: #fff;
    }

    #sidebar .active {
        background: #cc5200 !important;
        color: #fff !important;
    }

    /* Small device behavior */
    @media (max-width: 768px) {
        #sidebar {
            position: fixed;
            top: 0;
            left: -250px;
            width: 220px;
            z-index: 999;
        }
        #sidebar.show {
            left: 0;
        }
    }

    /* Toggle button */
    #sidebarToggle {
        display: none;
    }
    @media (max-width: 768px) {
        #sidebarToggle {
            display: block;
            margin: 10px;
        }
    }
</style>

<!-- SIDEBAR TOGGLE BUTTON (visible on phones) -->
<button class="btn btn-dark d-md-none" id="sidebarToggle">
    <i class="fa fa-bars"></i> Menu
</button>

<div class="col-md-2 sidebar collapse d-md-block" id="sidebar">
    <h5 class="text-center text-white mb-4">NAVIGATION MENU</h5>

    <ul class="nav flex-column">

        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>"
                href="../modules/dashboard.php">
                <i class="fa fa-home"></i> Dashboard
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'products') !== false ? 'active' : '' ?>"
                href="products/list_products.php">
                <i class="fa fa-cubes"></i> Products
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'suppliers') !== false ? 'active' : '' ?>"
                href="suppliers/index.php">
                <i class="fa fa-truck"></i> Suppliers
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'purchases') !== false ? 'active' : '' ?>"
                href="purchases/list_purchases.php">
                <i class="fa fa-shopping-cart"></i> Purchases
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'batches') !== false ? 'active' : '' ?>"
                href="../modules/products/list_batches.php">
                <i class="fa fa-tags"></i> Batches
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'sales') !== false ? 'active' : '' ?>"
                href="sales/list_sales.php">
                <i class="fa fa-dollar"></i> Sales
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'reports') !== false ? 'active' : '' ?>"
                href="reports/daily_sales.php">
                <i class="fa fa-chart-line"></i> Reports
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'reports') !== false ? 'active' : '' ?>"
                href="../auth/logout.php">
                <i class="fa fa-sign-out-alt"></i> Logout
            </a>
        </li>

    </ul>
</div>

<script>
    // Mobile toggle
    document.getElementById('sidebarToggle').onclick = function () {
        document.getElementById('sidebar').classList.toggle('show');
    };
</script>
