<?php
if (!isset($_SESSION)) session_start();
if (!isset($_SESSION['user'])) {
    header("Location: ../auth/login.php");
    exit;
}

$user = $_SESSION['user'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Pharmacy System</title>
<link rel="stylesheet" href="../libraries/bootstrap.css">
<link rel="stylesheet" href="../libraries/fontawesome-free-6.0.0-beta2-web/css/all.min.css">
<link rel="icon" href="../assets/img/favicon.jpg" type="image/x-icon">
<link rel="shortcut icon" href="../assets/img/favicon.jpg" type="image/x-icon">
<style>
  body {
    font-family: Arial, sans-serif;
    background-color: #f7f7f7;
}

/* Header & sidebar matching theme */
.navbar-custom { 
    background-color: #ff6600; /* Deep Orange */
}
.navbar-custom .navbar-brand,
.navbar-custom .nav-link,
.navbar-custom span {
    color: white !important;
    font-weight: 500;
}

/* Sidebar Theming */
.sidebar {
    background-color: #ff6600;
    min-height: 100vh;
    padding-top: 1rem;
    color: white;
}
.sidebar a { 
    color: #fff; 
    font-weight: 500; 
}
.sidebar a:hover { 
    background: rgba(255,255,255,0.2);
}

</style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-custom d-flex justify-content-between align-items-center">

    <!-- Logo + Title (centered in full layout) -->
    <div class="d-flex align-items-center mx-auto">
        <img src="../assets/img/favicon.jpg" 
             alt="Logo" 
             style="width: 40px; height: 40px; border-radius: 50%; margin-right: 10px;">
        <span class="navbar-brand mb-0 h4 text-white text-center">
            Pharmacy Management Information System<br>
            <small>Multishop Maagement Software</small>
        </span>
    </div>

    <!-- Mobile Sidebar Toggle -->
    <button class="navbar-toggler d-md-none text-white" 
            type="button" data-toggle="collapse" data-target="#sidebar">
        <i class="fas fa-bars"></i>
    </button>

    <!-- User Info -->
    <div class="d-none d-md-flex align-items-center" style="position: absolute; right: 20px;">
        <span class="mr-3 text-white">
            Hello, <?= htmlspecialchars($user['fullname']) ?>
        </span>
        <a class="btn btn-sm btn-dark" href="../auth/logout.php">Logout</a>
    </div>
</nav>

<div class="container-fluid">
    <div class="row">
