<?php
session_start();
require_once '../config/db_connect.php';

// (Optional) — later you can add admin-only restriction like:
// if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
//     header("Location: ../auth/login.php");
//     exit;
// }

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $fullname = trim($_POST['fullname']);
    $password = trim($_POST['password']);
    $role = $_POST['role'];

    if (!empty($username) && !empty($password) && !empty($role)) {
        // Check if username already exists
        $check = $pdo->prepare("SELECT id FROM users WHERE username = ?");
        $check->execute([$username]);

        if ($check->rowCount() > 0) {
            $message = "<div class='alert alert-warning text-center'>Username already exists!</div>";
        } else {
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

            $stmt = $pdo->prepare("INSERT INTO users (username, password_hash, fullname, role) VALUES (?, ?, ?, ?)");
            $stmt->execute([$username, $hashedPassword, $fullname, $role]);

            $message = "<div class='alert alert-success text-center'>User registered successfully!</div>";
        }
    } else {
        $message = "<div class='alert alert-danger text-center'>All fields are required.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register User | Pharmacy System</title>
    <link rel="stylesheet" href="../libraries/bootstrap.css">
    <style>
        body {
            background: #f1f8e9;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        .register-box {
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            width: 450px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h3 {
            color: #2e7d32;
            text-align: center;
            margin-bottom: 25px;
        }
        .btn-register {
            background-color: #2e7d32;
            color: white;
        }
        .btn-register:hover {
            background-color: #1b5e20;
        }
    </style>
</head>
<body>
    <div class="register-box">
        <h3>Create New User</h3>

        <?= $message ?>

        <form method="POST" action="">
            <div class="form-group mb-3">
                <label>Full Name</label>
                <input type="text" name="fullname" class="form-control" required>
            </div>

            <div class="form-group mb-3">
                <label>Username</label>
                <input type="text" name="username" class="form-control" required>
            </div>

            <div class="form-group mb-3">
                <label>Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>

            <div class="form-group mb-3">
                <label>Role</label>
                <select name="role" class="form-control" required>
                    <option value="">-- Select Role --</option>
                    <option value="admin">Admin</option>
                    <option value="pharmacist">Pharmacist</option>
                    <option value="cashier">Cashier</option>
                </select>
            </div>

            <button type="submit" class="btn btn-register w-100">Register</button>

            <div class="text-center mt-3">
                <a href="login.php">← Back to Login</a>
            </div>
        </form>
    </div>
</body>
</html>
