<?php
session_start();
require_once '../config/db_connect.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    $shop_id = isset($_POST['shop_id']) ? intval($_POST['shop_id']) : null;

    if ($username && $password) {
        $stmt = $pdo->prepare("SELECT u.*, s.name AS shop_name 
                               FROM users u 
                               LEFT JOIN shops s ON u.shop_id = s.id 
                               WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password_hash'])) {
            // Admin must select a shop
            if ($user['role'] === 'admin' && !$shop_id) {
                $error = "Please select a shop.";
            } else {
                // Store session data
                $_SESSION['user'] = [
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'fullname' => $user['fullname'],
                    'role' => $user['role'],
                    'shop_id' => $user['role'] === 'admin' ? $shop_id : $user['shop_id'],
                    'shop_name' => $user['role'] === 'admin' ? getShopName($shop_id, $pdo) : $user['shop_name']
                ];

                header("Location: ../modules/dashboard.php");
                exit;
            }
        } else {
            $error = "Invalid username or password.";
        }
    } else {
        $error = "Please enter both username and password.";
    }
}

// Function to get shop name
function getShopName($shop_id, $pdo){
    $stmt = $pdo->prepare("SELECT name FROM shops WHERE id = ?");
    $stmt->execute([$shop_id]);
    $shop = $stmt->fetch();
    return $shop ? $shop['name'] : '';
}

// Fetch shops for admin dropdown
$shopsStmt = $pdo->query("SELECT id, name FROM shops");
$shops = $shopsStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | Pharmacy System</title>
    <link rel="stylesheet" href="../libraries/bootstrap.css">
    <link rel="icon" href="../assets/img/favicon.jpg" type="image/x-icon">
<link rel="shortcut icon" href="../assets/img/favicon.jpg" type="image/x-icon">
    <style>
        body {
            background: #e8f5e9;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        .login-box {
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            width: 400px;
            padding: 30px;
        }
        .login-box h3 {
            color: #2e7d32;
            text-align: center;
            margin-bottom: 25px;
        }
        .btn-login {
            background-color: #2e7d32;
            color: white;
        }
        .btn-login:hover {
            background-color: #1b5e20;
        }
    </style>
</head>
<body>
    <div class="login-box">
        <h3>Pharmacy Management System</h3>

        <?php if ($error): ?>
            <div class="alert alert-danger text-center">
                <?= htmlspecialchars($error) ?>
            </div>
        <?php endif; ?>
<form method="POST" action="">
    <div class="form-group mb-3">
        <label>Username</label>
        <input type="text" name="username" class="form-control" required autofocus>
    </div>
    <div class="form-group mb-3">
        <label>Password</label>
        <input type="password" name="password" class="form-control" required>
    </div>
    <?php if (isset($user['role']) && $user['role'] === 'admin'): ?>
        <div class="form-group mb-3">
            <label>Select Shop</label>
            <select name="shop_id" class="form-control" required>
                <option value="">-- Choose Shop --</option>
                <?php foreach ($shops as $shop): ?>
                    <option value="<?= $shop['id'] ?>"><?= htmlspecialchars($shop['name']) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
    <?php endif; ?>
    <button type="submit" class="btn btn-login btn-block w-100">Login</button>
</form>

    </div>
</body>
</html>
