<?php
session_start();
require_once '../assets/db_connect.php';

echo "<h2>Testing Search Functionality</h2>";

// Test database connection
try {
    $pdo->query("SELECT 1");
    echo "<p style='color:green'>✓ Database connection successful</p>";
} catch (Exception $e) {
    echo "<p style='color:red'>✗ Database connection failed: " . $e->getMessage() . "</p>";
}

// Test if products exist
$stmt = $pdo->query("SELECT COUNT(*) as count FROM products WHERE is_active = 1");
$result = $stmt->fetch(PDO::FETCH_ASSOC);
echo "<p>Active products in database: " . $result['count'] . "</p>";

// Show some sample products
echo "<h3>Sample Products:</h3>";
$stmt = $pdo->query("SELECT id, sku, name FROM products WHERE is_active = 1 LIMIT 5");
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<ul>";
foreach ($products as $product) {
    echo "<li>ID: {$product['id']} - SKU: {$product['sku']} - Name: {$product['name']}</li>";
}
echo "</ul>";

// Test search query
echo "<h3>Test Search Query:</h3>";
$test_query = "paracetamol";
$sql = "SELECT id, sku, name FROM products WHERE (sku LIKE :query OR name LIKE :query) AND is_active = 1 LIMIT 5";
$stmt = $pdo->prepare($sql);
$searchTerm = "%{$test_query}%";
$stmt->bindParam(':query', $searchTerm);
$stmt->execute();
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (count($results) > 0) {
    echo "<p style='color:green'>✓ Search query works. Found " . count($results) . " results for '{$test_query}':</p>";
    echo "<ul>";
    foreach ($results as $result) {
        echo "<li>ID: {$result['id']} - SKU: {$result['sku']} - Name: {$result['name']}</li>";
    }
    echo "</ul>";
} else {
    echo "<p style='color:orange'>⚠ No results found for '{$test_query}'</p>";
}

// Test session
echo "<h3>Session Info:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";
?>