<?php
// test.php
echo "<h1>PHP Test Page</h1>";

// Test PHP is working
echo "<p>PHP Version: " . phpversion() . "</p>";

// Test session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
echo "<p>Session status: " . session_status() . "</p>";

// Test MySQL connection
try {
    $pdo = new PDO('mysql:host=127.0.0.1;dbname=pharmacy_db;charset=utf8mb4', 'root', '');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "<p style='color: green;'>✅ Database connection successful!</p>";
    
    // Test a simple query
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM products");
    $result = $stmt->fetch();
    echo "<p>Products in database: " . $result['count'] . "</p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Database connection failed: " . $e->getMessage() . "</p>";
}

// Check if we're logged in
if (isset($_SESSION['user'])) {
    echo "<p>✅ User is logged in: " . $_SESSION['user']['username'] . "</p>";
} else {
    echo "<p>❌ User is NOT logged in</p>";
    echo '<a href="../../auth/login.php">Go to Login</a>';
}

// Check file permissions
echo "<h2>File Permissions:</h2>";
$files = ['test.php', '../../auth/check_session.php', 'config/database.php'];
foreach ($files as $file) {
    if (file_exists($file)) {
        echo "<p>✅ $file exists</p>";
    } else {
        echo "<p style='color: red;'>❌ $file does NOT exist</p>";
    }
}
?>