<?php
require '../assets/db_connect.php';

$term = trim($_GET['term'] ?? '');
if (!$term) exit(json_encode([]));

// Search products by name (limit 10)
$stmt = $pdo->prepare("SELECT id, name FROM products WHERE name LIKE ? ORDER BY name LIMIT 10");
$stmt->execute(["%$term%"]);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

$data = [];
foreach ($products as $p) {
    $data[] = [
        'id' => $p['id'],
        'text' => $p['name']
    ];
}

echo json_encode($data);
