<?php
// ajax/update_batch_status.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once '../../assets/db_connect.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user']) || $_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$batch_id = $_POST['batch_id'] ?? 0;
$is_active = $_POST['is_active'] ?? 0;

try {
    $stmt = $pdo->prepare("UPDATE product_batches SET is_active = ? WHERE id = ?");
    $stmt->execute([$is_active, $batch_id]);
    
    $action = $is_active ? 'activated' : 'deactivated';
    echo json_encode(['status' => 'success', 'message' => "Batch has been $action"]);
    
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Error: ' . $e->getMessage()]);
}
?>