<?php
session_start();
require_once '../../assets/db_connect.php';
require_once '../../includes/header.php';
require_once '../../includes/sidebar.php';

$invoice_no = 'SALE-' . date('Ymd') . '-' . rand(100,999);
?>

<div class="content-wrapper">
<section class="content-header">
    <h1>
        Point of Sale
        <small>Sell products</small>
    </h1>
</section>

<section class="content">

<div class="row">
<div class="col-md-8">

<!-- SEARCH -->
<div class="card">
    <div class="card-header bg-primary text-white">
        <h3 class="card-title">
            <i class="fas fa-search"></i> Search Product
        </h3>
    </div>

    <div class="card-body">
        <input type="text" id="productSearch"
               class="form-control form-control-lg"
               placeholder="Scan barcode or type product name">
        <div id="searchResults" class="list-group mt-2"></div>
    </div>
</div>

<!-- CART -->
<div class="card mt-3">
    <div class="card-header bg-dark text-white">
        <h3 class="card-title">
            <i class="fas fa-shopping-cart"></i> Cart
        </h3>
    </div>

    <div class="card-body p-0">
        <form id="posForm">
        <input type="hidden" name="invoice_no" value="<?= $invoice_no ?>">

        <table class="table table-striped table-hover mb-0">
            <thead class="thead-light">
            <tr>
                <th>Product</th>
                <th width="80">Stock</th>
                <th width="100">Price</th>
                <th width="80">Qty</th>
                <th width="80">VAT</th>
                <th width="120">Total</th>
                <th width="40"></th>
            </tr>
            </thead>
            <tbody id="cartBody">
                <tr id="emptyRow">
                    <td colspan="7" class="text-center text-muted py-4">
                        No items added
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

</div><!-- col-md-8 -->

<!-- PAYMENT PANEL -->
<div class="col-md-4">

<div class="card">
    <div class="card-header bg-success text-white">
        <h3 class="card-title">
            <i class="fas fa-credit-card"></i> Payment
        </h3>
    </div>

    <div class="card-body">
        <div class="form-group">
            <label>Total Amount</label>
            <input type="text" id="grandTotal"
                   class="form-control form-control-lg text-right font-weight-bold"
                   readonly value="0.00">
        </div>

        <div class="form-group">
            <label>Payment Method</label>
            <select name="payment_method" class="form-control form-control-lg" required>
                <option value="CASH">Cash</option>
                <option value="M-PESA">M-PESA</option>
                <option value="CARD">Card</option>
            </select>
        </div>

        <div class="form-group">
            <label>Amount Paid</label>
            <input type="number" name="amount_paid"
                   class="form-control form-control-lg text-right"
                   step="0.01" required>
        </div>

        <button class="btn btn-success btn-lg btn-block">
            <i class="fas fa-check-circle"></i> Complete Sale
        </button>
    </div>
</div>

</div><!-- col-md-4 -->
</div><!-- row -->

</section>
</div>

<?php require_once '../../includes/footer.php'; ?>
