<?php
session_start();
require_once '../../assets/db_connect.php';

if (!isset($_SESSION['user']['id'])) {
    echo '<div class="alert alert-danger">Unauthorized access</div>';
    exit();
}

$product_id = $_GET['product_id'] ?? 0;
$product_id = intval($product_id);
$shop_id = $_SESSION['user']['shop_id'];

// Get all sales for this product
$sql = "SELECT 
            sl.sale_id,
            sa.invoice_no,
            sa.sale_date,
            sl.qty,
            sl.unit_price,
            sl.line_total,
            c.name as customer_name,
            u.fullname as created_by_name
        FROM sale_lines sl
        JOIN sales sa ON sl.sale_id = sa.id
        LEFT JOIN customers c ON sa.customer_id = c.id
        LEFT JOIN users u ON sa.created_by = u.id
        WHERE sl.product_id = ?
        AND sa.shop_id = ?
        ORDER BY sa.sale_date DESC
        LIMIT 50";

$stmt = $pdo->prepare($sql);
$stmt->execute([$product_id, $shop_id]);
$sales = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get product name
$product_sql = "SELECT name FROM products WHERE id = ?";
$product_stmt = $pdo->prepare($product_sql);
$product_stmt->execute([$product_id]);
$product = $product_stmt->fetch(PDO::FETCH_ASSOC);
$product_name = $product['name'] ?? 'Product #' . $product_id;
?>

<div class="container-fluid">
    <h4 class="text-success mb-3">
        <i class="fas fa-chart-line"></i> Sales History for: <?= htmlspecialchars($product_name) ?>
    </h4>
    
    <?php if(empty($sales)): ?>
    <div class="alert alert-info">
        <i class="fas fa-info-circle"></i> No sales history found for this product.
    </div>
    <?php else: ?>
    <div class="table-responsive">
        <table class="table table-bordered table-hover">
            <thead class="thead-dark">
                <tr>
                    <th>#</th>
                    <th>Invoice No</th>
                    <th>Date & Time</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Line Total</th>
                    <th>Customer</th>
                    <th>Sold By</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $total_qty = 0;
                $total_value = 0;
                foreach($sales as $index => $sale): 
                    $total_qty += $sale['qty'];
                    $total_value += $sale['line_total'];
                ?>
                <tr>
                    <td><?= $index + 1 ?></td>
                    <td><strong><?= htmlspecialchars($sale['invoice_no']) ?></strong></td>
                    <td><?= date('M d, Y H:i', strtotime($sale['sale_date'])) ?></td>
                    <td class="text-center"><?= $sale['qty'] ?></td>
                    <td class="text-right"><?= number_format($sale['unit_price'], 2) ?></td>
                    <td class="text-right"><?= number_format($sale['line_total'], 2) ?></td>
                    <td><?= htmlspecialchars($sale['customer_name'] ?? 'Walk-in') ?></td>
                    <td><?= htmlspecialchars($sale['created_by_name'] ?? 'System') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot class="bg-light">
                <tr>
                    <td colspan="3" class="text-right"><strong>Totals:</strong></td>
                    <td class="text-center"><strong><?= $total_qty ?></strong></td>
                    <td></td>
                    <td class="text-right"><strong><?= number_format($total_value, 2) ?></strong></td>
                    <td colspan="2"></td>
                </tr>
            </tfoot>
        </table>
    </div>
    <div class="mt-3">
        <p class="text-muted">
            <small>Showing <?= count($sales) ?> sales records</small>
        </p>
    </div>
    <?php endif; ?>
    
    <div class="mt-4 text-center">
        <button class="btn btn-secondary" onclick="Swal.close()">
            <i class="fas fa-times"></i> Close
        </button>
    </div>
</div>