<?php
// modules/sales/new_sale.php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

$shop_id = $_SESSION['user']['shop_id'] ?? 0;

if ($shop_id == 0) {
    die("Shop session missing.");
}
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h3 class="text-success mb-0">
                <i class="fas fa-cash-register"></i> New Sale
            </h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb bg-transparent p-0">
                    <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="list_sales.php">Sales</a></li>
                    <li class="breadcrumb-item active">New Sale</li>
                </ol>
            </nav>
        </div>
        <div>
            <a href="list_sales.php" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Sales
            </a>
        </div>
    </div>
    
    <div class="alert alert-warning">
        <i class="fas fa-exclamation-triangle"></i> 
        The full POS system is being developed. For now, please use the 
        <a href="ajax/pos.php" class="alert-link">Basic POS System</a>
        or create sales manually.
    </div>
    
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="fas fa-calculator"></i> Quick Sale</h5>
                </div>
                <div class="card-body">
                    <form action="save_sale.php" method="POST">
                        <div class="mb-3">
                            <label class="form-label">Product</label>
                            <select name="product_id" class="form-control" required>
                                <option value="">Select Product</option>
                                <?php
                                $products_sql = "SELECT p.id, p.name, p.sku, SUM(pb.qty) as stock 
                                                FROM products p 
                                                LEFT JOIN product_batches pb ON p.id = pb.product_id 
                                                WHERE p.shop_id = ? AND p.is_active = 1
                                                GROUP BY p.id 
                                                HAVING stock > 0";
                                $products_stmt = $pdo->prepare($products_sql);
                                $products_stmt->execute([$shop_id]);
                                while ($product = $products_stmt->fetch()) {
                                    echo "<option value='{$product['id']}'>
                                        {$product['name']} ({$product['sku']}) - Stock: {$product['stock']}
                                    </option>";
                                }
                                ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Quantity</label>
                            <input type="number" name="quantity" class="form-control" min="1" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Price per unit</label>
                            <input type="number" name="price" class="form-control" step="0.01" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Customer (Optional)</label>
                            <select name="customer_id" class="form-control">
                                <option value="">Walk-in Customer</option>
                                <?php
                                $customers_sql = "SELECT * FROM customers WHERE shop_id = ? OR shop_id IS NULL";
                                $customers_stmt = $pdo->prepare($customers_sql);
                                $customers_stmt->execute([$shop_id]);
                                while ($customer = $customers_stmt->fetch()) {
                                    echo "<option value='{$customer['id']}'>{$customer['name']}</option>";
                                }
                                ?>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-success w-100">
                            <i class="fas fa-check"></i> Process Sale
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="fas fa-bolt"></i> Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <a href="ajax/pos.php" class="btn btn-primary w-100 py-3">
                                <i class="fas fa-cash-register fa-2x mb-2"></i><br>
                                POS System
                            </a>
                        </div>
                        <div class="col-md-4 mb-3">
                            <a href="list_sales.php" class="btn btn-success w-100 py-3">
                                <i class="fas fa-list fa-2x mb-2"></i><br>
                                View Sales
                            </a>
                        </div>
                        <div class="col-md-4 mb-3">
                            <a href="../products/manage_products.php" class="btn btn-warning w-100 py-3">
                                <i class="fas fa-box fa-2x mb-2"></i><br>
                                Manage Products
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>