<?php
// modules/sales/export_sales_pdf.php (simple HTML to PDF alternative)
session_start();
require_once '../assets/db_connect.php';

$shop_id = $_SESSION['user']['shop_id'] ?? 0;

if ($shop_id == 0) {
    die("Shop session missing.");
}

// Get filter parameters
$from_date = $_GET['from_date'] ?? date('Y-m-d', strtotime('-30 days'));
$to_date = $_GET['to_date'] ?? date('Y-m-d');

// Simply redirect to the print version for now
// In a real implementation, you would use a PDF library here

// For now, we'll just serve the HTML with print styling
header('Content-Type: text/html');
?>

<!DOCTYPE html>
<html>
<head>
    <style>
        @media print {
            @page { margin: 0; }
            body { margin: 1.6cm; }
        }
        body { font-family: Arial; }
        h1 { color: #27ae60; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background: #f2f2f2; }
    </style>
</head>
<body>
    <h1>Sales Report (PDF)</h1>
    <p>Period: <?= $from_date ?> to <?= $to_date ?></p>
    <p>To implement full PDF export, install a PDF library like TCPDF or Dompdf.</p>
    <p>For now, use the Print Report function and choose "Save as PDF" in your print dialog.</p>
    
    <script>
        setTimeout(() => {
            window.print();
            setTimeout(() => window.close(), 1000);
        }, 500);
    </script>
</body>
</html>