<?php
// modules/sales/barcode.php
require_once '../assets/db_connect.php';

$text = $_GET['text'] ?? '';

// Generate barcode image using GD library
header('Content-Type: image/png');
$width = 300;
$height = 100;

$im = imagecreatetruecolor($width, $height);
$white = imagecolorallocate($im, 255, 255, 255);
$black = imagecolorallocate($im, 0, 0, 0);

imagefilledrectangle($im, 0, 0, $width, $height, $white);

// Simple barcode simulation
for($i = 0; $i < strlen($text); $i++) {
    $char = ord($text[$i]);
    $x = 10 + ($i * 10);
    $bar_height = 50 + ($char % 30);
    imagefilledrectangle($im, $x, 20, $x + 5, $bar_height, $black);
}

// Add text below
imagestring($im, 5, 50, 75, $text, $black);

imagepng($im);
imagedestroy($im);
?>