<?php
session_start();
require_once '../assets/db_connect.php';

header('Content-Type: application/json');

try {
    $name = $_POST['name'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $email = $_POST['email'] ?? '';
    $address = $_POST['address'] ?? '';
    $shop_id = $_POST['shop_id'] ?? 0;

    if (empty($name)) {
        throw new Exception('Customer name is required');
    }

    $sql = "INSERT INTO customers (name, phone, email, address, shop_id) 
            VALUES (?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$name, $phone, $email, $address, $shop_id]);

    echo json_encode([
        'status' => 'success',
        'message' => 'Customer saved successfully',
        'customer_id' => $pdo->lastInsertId(),
        'customer_name' => $name
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}