<?php
session_start();
require_once '../assets/db_connect.php';

$shop_id = $_GET['shop_id'] ?? 0;

// Get products with stock info
$sql = "SELECT 
            p.*,
            COALESCE(SUM(bs.current_qty), 0) as total_qty
        FROM products p
        LEFT JOIN batch_stock_view bs ON p.id = bs.product_id 
            AND bs.shop_id = ? 
            AND bs.current_qty > 0
            AND bs.is_active = 1
        WHERE p.shop_id = ? 
        AND p.is_active = 1
        GROUP BY p.id
        ORDER BY p.name";

$stmt = $pdo->prepare($sql);
$stmt->execute([$shop_id, $shop_id]);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

header('Content-Type: application/json');
echo json_encode([
    'status' => 'success',
    'count' => count($products),
    'products' => $products
]);